/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.msexchange;

import org.opennms.netmgt.provision.detector.msexchange.client.MSExchangeDetectorClient;
import org.opennms.netmgt.provision.detector.msexchange.response.MSExchangeResponse;
import org.opennms.netmgt.provision.detector.simple.request.LineOrientedRequest;
import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ResponseValidator;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class MSExchangeDetector
extends BasicDetector<LineOrientedRequest, MSExchangeResponse> {
    private static String SERVICE_NAME = "MSExchange";
    private static String DEFAULT_BANNER = "Microsoft Exchange";
    private static int DEFAULT_POP3_PORT = 110;
    private static int DEFAULT_IMAP_PORT = 143;
    private int m_pop3Port;
    private int m_imapPort;

    protected MSExchangeDetector() {
        super(SERVICE_NAME, 0);
        this.setPop3Port(DEFAULT_POP3_PORT);
        this.setImapPort(DEFAULT_IMAP_PORT);
    }

    protected Client<LineOrientedRequest, MSExchangeResponse> getClient() {
        MSExchangeDetectorClient client = new MSExchangeDetectorClient();
        client.setImapPort(this.getImapPort());
        client.setPop3Port(this.getPop3Port());
        return client;
    }

    protected void onInit() {
        this.expectBanner(MSExchangeDetector.find(DEFAULT_BANNER));
    }

    protected static ResponseValidator<MSExchangeResponse> find(final String regex) {
        return new ResponseValidator<MSExchangeResponse>(){

            public boolean validate(MSExchangeResponse response) {
                return response.contains(regex);
            }
        };
    }

    public void setPop3Port(int pop3Port) {
        this.m_pop3Port = pop3Port;
    }

    public int getPop3Port() {
        return this.m_pop3Port;
    }

    public void setImapPort(int imapPort) {
        this.m_imapPort = imapPort;
    }

    public int getImapPort() {
        return this.m_imapPort;
    }
}

