/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple;

import org.opennms.netmgt.provision.detector.simple.client.TrivialTimeClient;
import org.opennms.netmgt.provision.detector.simple.request.TrivialTimeRequest;
import org.opennms.netmgt.provision.detector.simple.response.TrivialTimeResponse;
import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ResponseValidator;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class TrivialTimeDetector
extends BasicDetector<TrivialTimeRequest, TrivialTimeResponse> {
    private static final String DEFAULT_SERVICE_NAME = "TrivialTime";
    private static final String DEFAULT_PROTOCOL = "tcp";
    private static final int DEFAULT_PORT = 37;
    private static final int DEFAULT_ALLOWED_SKEW = 30;
    private String protocol = "tcp";
    private int allowedSkew = 30;

    public TrivialTimeDetector() {
        super(DEFAULT_SERVICE_NAME, 37);
    }

    public TrivialTimeDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    protected void onInit() {
        this.send(this.request(), TrivialTimeDetector.validate());
    }

    private TrivialTimeRequest request() {
        return new TrivialTimeRequest();
    }

    private static ResponseValidator<TrivialTimeResponse> validate() {
        return new ResponseValidator<TrivialTimeResponse>(){

            public boolean validate(TrivialTimeResponse response) {
                return response.isAvailable();
            }
        };
    }

    protected Client<TrivialTimeRequest, TrivialTimeResponse> getClient() {
        TrivialTimeClient client = new TrivialTimeClient(this.getProtocol(), this.getAllowedSkew());
        client.setRetries(this.getRetries());
        return client;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public int getAllowedSkew() {
        return this.allowedSkew;
    }

    public void setAllowedSkew(int allowedSkew) {
        this.allowedSkew = allowedSkew;
    }
}

