/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple;

import java.nio.charset.Charset;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.Delimiters;
import org.jboss.netty.handler.codec.string.StringDecoder;
import org.jboss.netty.handler.codec.string.StringEncoder;
import org.jboss.netty.util.CharsetUtil;
import org.opennms.netmgt.provision.detector.simple.request.LineOrientedRequest;
import org.opennms.netmgt.provision.detector.simple.response.LineOrientedResponse;
import org.opennms.netmgt.provision.detector.simple.support.LineOrientedRequestEncoder;
import org.opennms.netmgt.provision.detector.simple.support.LineOrientedResponseDecoder;
import org.opennms.netmgt.provision.support.AsyncBasicDetectorNettyImpl;
import org.opennms.netmgt.provision.support.ResponseValidator;

public abstract class AsyncLineOrientedDetectorNettyImpl
extends AsyncBasicDetectorNettyImpl<LineOrientedRequest, LineOrientedResponse> {
    protected static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");

    public AsyncLineOrientedDetectorNettyImpl(String serviceName, int port) {
        super(serviceName, port);
    }

    public AsyncLineOrientedDetectorNettyImpl(String serviceName, int port, int timeout, int retries) {
        super(serviceName, port, timeout, retries);
    }

    protected ResponseValidator<LineOrientedResponse> startsWith(final String prefix) {
        return new ResponseValidator<LineOrientedResponse>(){

            public boolean validate(LineOrientedResponse response) {
                return response.startsWith(prefix);
            }
        };
    }

    public ResponseValidator<LineOrientedResponse> find(final String regex) {
        return new ResponseValidator<LineOrientedResponse>(){

            public boolean validate(LineOrientedResponse response) {
                return response.find(regex);
            }
        };
    }

    public LineOrientedRequest request(String command) {
        return new LineOrientedRequest(command);
    }

    protected void appendToPipeline(ChannelPipeline retval) {
        retval.addLast("frameDecoder", (ChannelHandler)new DelimiterBasedFrameDecoder(1024, Delimiters.lineDelimiter()));
        retval.addLast("stringDecoder", (ChannelHandler)new StringDecoder(CharsetUtil.UTF_8));
        retval.addLast("lineDecoder", (ChannelHandler)new LineOrientedResponseDecoder());
        retval.addLast("stringEncoder", (ChannelHandler)new StringEncoder(CharsetUtil.UTF_8));
        retval.addLast("lineEncoder", (ChannelHandler)new LineOrientedRequestEncoder());
    }
}

