/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.support;

import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneDecoder;
import org.opennms.netmgt.provision.detector.simple.response.MultilineOrientedResponse;

public class MultilineOrientedResponseDecoder
extends OneToOneDecoder {
    public static final String DEFAULT_MULTILINE_INDICATOR = "-";
    private final String m_multilineIndicator;
    private MultilineOrientedResponse m_response;

    public MultilineOrientedResponseDecoder() {
        this(DEFAULT_MULTILINE_INDICATOR);
    }

    public MultilineOrientedResponseDecoder(String multilineIndicator) {
        this.m_multilineIndicator = multilineIndicator;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof String)) {
            return msg;
        }
        if (this.m_response == null) {
            this.m_response = new MultilineOrientedResponse();
        }
        String response = (String)msg;
        this.m_response.addLine(response);
        if (this.checkIndicator(response)) {
            return null;
        }
        MultilineOrientedResponse retval = this.m_response;
        this.m_response = null;
        return retval;
    }

    protected boolean checkIndicator(String line) {
        return line.substring(3, 4).equals(this.getMultilineIndicator());
    }

    public String getMultilineIndicator() {
        return this.m_multilineIndicator;
    }
}

