/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.opennms.core.utils.SocketUtils;
import org.opennms.netmgt.provision.detector.simple.client.MultilineOrientedClient;
import org.opennms.netmgt.provision.detector.simple.request.LineOrientedRequest;
import org.opennms.netmgt.provision.detector.simple.response.MultilineOrientedResponse;
import org.opennms.netmgt.provision.support.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLClient
extends MultilineOrientedClient
implements Client<LineOrientedRequest, MultilineOrientedResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(SSLClient.class);

    @Override
    public void connect(InetAddress address, int port, int timeout) throws IOException {
        this.m_socket = this.getWrappedSocket(address, port, timeout);
        this.setOutput(this.m_socket.getOutputStream());
        this.setInput(new BufferedReader(new InputStreamReader(this.m_socket.getInputStream())));
    }

    protected Socket getWrappedSocket(InetAddress address, int port, int timeout) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(address, port), timeout);
        socket.setSoTimeout(timeout);
        try {
            return SocketUtils.wrapSocketInSslContext((Socket)socket);
        }
        catch (Exception e) {
            LOG.debug("Unable to wrap socket in SSL.", (Throwable)e);
            return null;
        }
    }
}

