/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.opennms.core.utils.SocketUtils;
import org.opennms.core.utils.SocketWrapper;
import org.opennms.netmgt.provision.detector.simple.request.NrpeRequest;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.nrpe.NrpePacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NrpeClient
implements Client<NrpeRequest, NrpePacket>,
SocketWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(NrpeClient.class);
    private static final String[] ADH_CIPHER_SUITES = new String[]{"TLS_DH_anon_WITH_AES_128_CBC_SHA"};
    private Socket m_socket;
    private int m_padding = 2;
    private boolean m_useSsl = true;
    private OutputStream m_out;
    private InputStream m_in;

    public void close() {
        Socket socket = this.m_socket;
        this.m_socket = null;
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException e) {
            LOG.debug("failed to close socket", (Throwable)e);
        }
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        this.m_socket = this.getWrappedSocket(address, port, timeout);
        this.setOutput(this.m_socket.getOutputStream());
        this.setInput(this.m_socket.getInputStream());
    }

    protected Socket getWrappedSocket(InetAddress address, int port, int timeout) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(address, port), timeout);
        socket.setSoTimeout(timeout);
        try {
            return this.wrapSocket(socket);
        }
        catch (IOException e) {
            LOG.debug("an error occurred while SSL-wrapping a socket ({}:{})", new Object[]{address, port, e});
            return null;
        }
    }

    public Socket wrapSocket(Socket socket) throws IOException {
        if (!this.isUseSsl()) {
            return socket;
        }
        return SocketUtils.wrapSocketInSslContext((Socket)socket, (String[])ADH_CIPHER_SUITES);
    }

    public NrpePacket receiveBanner() throws IOException, Exception {
        return this.receiveResponse();
    }

    public NrpePacket sendRequest(NrpeRequest request) throws IOException, Exception {
        request.send(this.getOutput());
        return this.receiveResponse();
    }

    private NrpePacket receiveResponse() throws Exception {
        NrpePacket response = NrpePacket.receivePacket(this.getInput(), this.getPadding());
        LOG.info("what is response: {}", (Object)response.getResultCode());
        return response;
    }

    public void setPadding(int padding) {
        this.m_padding = padding;
    }

    public int getPadding() {
        return this.m_padding;
    }

    public void setUseSsl(boolean useSsl) {
        this.m_useSsl = useSsl;
    }

    public boolean isUseSsl() {
        return this.m_useSsl;
    }

    public void setOutput(OutputStream out) {
        this.m_out = out;
    }

    public OutputStream getOutput() {
        return this.m_out;
    }

    public void setInput(InputStream in) {
        this.m_in = in;
    }

    public InputStream getInput() {
        return this.m_in;
    }
}

