/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple;

import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.Delimiters;
import org.jboss.netty.handler.codec.string.StringDecoder;
import org.jboss.netty.handler.codec.string.StringEncoder;
import org.jboss.netty.util.CharsetUtil;
import org.opennms.netmgt.provision.detector.simple.request.LineOrientedRequest;
import org.opennms.netmgt.provision.detector.simple.response.MultilineOrientedResponse;
import org.opennms.netmgt.provision.detector.simple.support.LineOrientedRequestEncoder;
import org.opennms.netmgt.provision.detector.simple.support.MultilineOrientedResponseDecoder;
import org.opennms.netmgt.provision.support.AsyncBasicDetectorNettyImpl;
import org.opennms.netmgt.provision.support.ResponseValidator;

public abstract class AsyncMultilineDetectorNettyImpl
extends AsyncBasicDetectorNettyImpl<LineOrientedRequest, MultilineOrientedResponse> {
    public AsyncMultilineDetectorNettyImpl(String serviceName, int port) {
        super(serviceName, port);
    }

    public AsyncMultilineDetectorNettyImpl(String serviceName, int port, int timeout, int retries) {
        super(serviceName, port, timeout, retries);
    }

    protected static ResponseValidator<MultilineOrientedResponse> expectCodeRange(final int beginRange, final int endRange) {
        return new ResponseValidator<MultilineOrientedResponse>(){

            public boolean validate(MultilineOrientedResponse response) {
                return response.expectedCodeRange(beginRange, endRange);
            }
        };
    }

    public ResponseValidator<MultilineOrientedResponse> startsWith(final String pattern) {
        return new ResponseValidator<MultilineOrientedResponse>(){

            public boolean validate(MultilineOrientedResponse response) {
                return response.startsWith(pattern);
            }
        };
    }

    public LineOrientedRequest request(String command) {
        return new LineOrientedRequest(command);
    }

    protected void appendToPipeline(ChannelPipeline retval) {
        retval.addLast("frameDecoder", (ChannelHandler)new DelimiterBasedFrameDecoder(1024, Delimiters.lineDelimiter()));
        retval.addLast("stringDecoder", (ChannelHandler)new StringDecoder(CharsetUtil.UTF_8));
        retval.addLast("multilineDecoder", (ChannelHandler)new MultilineOrientedResponseDecoder());
        retval.addLast("stringEncoder", (ChannelHandler)new StringEncoder(CharsetUtil.UTF_8));
        retval.addLast("lineEncoder", (ChannelHandler)new LineOrientedRequestEncoder());
    }
}

