/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple;

import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.opennms.netmgt.provision.detector.simple.AsyncLineOrientedDetectorMinaImpl;
import org.opennms.netmgt.provision.detector.simple.request.LineOrientedRequest;
import org.opennms.netmgt.provision.detector.simple.response.LineOrientedResponse;
import org.opennms.netmgt.provision.detector.simple.support.TcpDetectorHandler;
import org.opennms.netmgt.provision.support.ConversationExchange;
import org.opennms.netmgt.provision.support.ResponseValidator;
import org.opennms.netmgt.provision.support.codec.TcpCodecFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class TcpDetector
extends AsyncLineOrientedDetectorMinaImpl {
    private static final String DEFAULT_SERVICE_NAME = "TCP";
    private static final int DEFAULT_PORT = 23;
    private String m_banner = null;

    public TcpDetector() {
        this(DEFAULT_SERVICE_NAME, 23);
    }

    public TcpDetector(String serviceName, int port) {
        super(serviceName, port);
        this.setDetectorHandler(new TcpDetectorHandler());
        this.setProtocolCodecFilter(new ProtocolCodecFilter((ProtocolCodecFactory)new TcpCodecFactory(CHARSET_UTF8)));
    }

    protected void onInit() {
        if (this.getBanner() != null) {
            this.expectBanner(TcpDetector.matches(this.getBanner()));
        } else {
            this.getConversation().addExchange(TcpDetector.testBannerlessConnection());
        }
    }

    private static ConversationExchange<LineOrientedRequest, LineOrientedResponse> testBannerlessConnection() {
        return new ConversationExchange<LineOrientedRequest, LineOrientedResponse>(){

            public boolean validate(LineOrientedResponse response) {
                return response.equals("___OPENNMS_NO_TCP_BANNER_RECEIVED___");
            }

            public LineOrientedRequest getRequest() {
                return null;
            }
        };
    }

    public static ResponseValidator<LineOrientedResponse> matches(final String regex) {
        return new ResponseValidator<LineOrientedResponse>(){

            public boolean validate(LineOrientedResponse response) {
                return response.matches(regex) && !response.equals("___OPENNMS_NO_TCP_BANNER_RECEIVED___");
            }
        };
    }

    public void setBanner(String banner) {
        this.m_banner = banner;
    }

    public String getBanner() {
        return this.m_banner;
    }
}

