/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.detector.simple.request.TrivialTimeRequest;
import org.opennms.netmgt.provision.detector.simple.response.TrivialTimeResponse;
import org.opennms.netmgt.provision.support.Client;

public class TrivialTimeClient
implements Client<TrivialTimeRequest, TrivialTimeResponse> {
    private static final int EPOCH_ADJ_FACTOR = 2085978496;
    private String protocol;
    private int allowedSkew;
    private int retries;
    private Socket tcpSocket;
    private DatagramSocket udpSocket;
    private DatagramPacket udpPacket;

    public TrivialTimeClient(String protocol, int allowedSkew) {
        this.protocol = protocol;
        this.allowedSkew = allowedSkew;
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        if (!this.isTcp() && !this.isUdp()) {
            throw new IllegalArgumentException("Unsupported protocol, only TCP and UDP currently supported");
        }
        if (this.isUdp()) {
            this.log().warn("UDP support is largely untested");
        }
        if (this.isTcp()) {
            this.tcpSocket = new Socket();
            this.tcpSocket.connect(new InetSocketAddress(address, port), timeout);
            this.tcpSocket.setSoTimeout(timeout);
        } else {
            this.udpSocket = new DatagramSocket();
            this.udpSocket.setSoTimeout(timeout);
            this.udpPacket = new DatagramPacket(new byte[0], 0, address, port);
        }
        this.log().debug("Connected to host: " + address + " on " + this.protocol.toUpperCase() + " port: " + port);
    }

    public void close() {
        try {
            if (this.isTcp() && this.tcpSocket != null) {
                this.tcpSocket.close();
            }
            if (this.isUdp() && this.udpSocket != null) {
                this.udpSocket.close();
            }
        }
        catch (Exception e) {
            this.log().error("Can't close detector sockets.", (Throwable)e);
        }
    }

    public TrivialTimeResponse receiveBanner() throws IOException, Exception {
        return null;
    }

    public TrivialTimeResponse sendRequest(TrivialTimeRequest request) throws IOException, Exception {
        boolean gotTime = false;
        int remoteTime = 0;
        int localTime = 0;
        for (int i = 0; i < this.retries && !gotTime; ++i) {
            byte[] timeBytes = new byte[4];
            ByteBuffer timeByteBuffer = ByteBuffer.wrap(timeBytes);
            int bytesRead = 0;
            if (this.isTcp()) {
                bytesRead = this.tcpSocket.getInputStream().read(timeBytes);
            }
            if (this.isUdp()) {
                this.udpSocket.send(this.udpPacket);
                DatagramPacket timePacket = new DatagramPacket(timeBytes, timeBytes.length);
                this.udpSocket.receive(timePacket);
                bytesRead = timePacket.getLength();
            }
            if (bytesRead != 4) continue;
            if (this.log().isDebugEnabled()) {
                this.log().debug("sendRequest: " + this.protocol + " bytes read = " + bytesRead);
            }
            try {
                remoteTime = timeByteBuffer.getInt();
            }
            catch (BufferUnderflowException bue) {
                this.log().error("Encountered buffer underflow while reading time from remote socket.");
                remoteTime = 0;
                continue;
            }
            localTime = (int)(System.currentTimeMillis() / 1000L) - 2085978496;
            gotTime = true;
        }
        return gotTime ? new TrivialTimeResponse(remoteTime, localTime, this.allowedSkew) : new TrivialTimeResponse();
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    private boolean isTcp() {
        return this.protocol.equalsIgnoreCase("tcp");
    }

    private boolean isUdp() {
        return this.protocol.equalsIgnoreCase("udp");
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

