/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support.codec;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.detector.simple.request.LineOrientedRequest;

public class LineOrientedEncoder
extends ProtocolEncoderAdapter {
    private final AttributeKey ENCODER = new AttributeKey(((Object)((Object)this)).getClass(), "encoder");
    private final Charset m_charset;

    public LineOrientedEncoder(Charset charset) {
        this.m_charset = charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        LineOrientedRequest request = (LineOrientedRequest)message;
        if (request.getRequest().contains("null")) {
            return;
        }
        CharsetEncoder encoder = (CharsetEncoder)session.getAttribute((Object)this.ENCODER);
        if (encoder == null) {
            encoder = this.m_charset.newEncoder();
            session.setAttribute((Object)this.ENCODER, (Object)encoder);
        }
        String value = request.getRequest();
        IoBuffer buffer = null;
        try {
            buffer = IoBuffer.allocate((int)value.length()).setAutoExpand(true);
            buffer.putString((CharSequence)request.getRequest(), encoder);
            buffer.flip();
            LogUtils.debugf((Object)((Object)this), (String)"Client sending: %s", (Object[])new Object[]{value.trim()});
            out.write((Object)buffer);
        }
        finally {
            if (buffer != null) {
                buffer.free();
            }
        }
    }
}

