/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.response;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.detector.simple.response.LineOrientedResponse;

public class HttpStatusResponse
extends LineOrientedResponse {
    private static final Pattern DEFAULT_REGEX = Pattern.compile("([H][T][T][P+]/[1].[0-1]) ([0-6]+) ([a-zA-Z ]+)");

    public HttpStatusResponse(String response) {
        super(response);
    }

    public boolean validateResponse(String pattern, String url, boolean isCheckCode, int maxRetCode) throws Exception {
        String[] codeArray = Integer.toString(maxRetCode).split("");
        if (codeArray.length < 3) {
            throw new IllegalArgumentException("Maximum HTTP return code is too short, must be at least 3 digits");
        }
        Pattern p = isCheckCode ? Pattern.compile(String.format("([H][T][T][P+]/[1].[0-1]) ([0-%s][0-2][0-%s]) ([a-zA-Z ]+)", codeArray[1], codeArray[3])) : DEFAULT_REGEX;
        Matcher m = p.matcher(this.getResponse().trim());
        LogUtils.infof((Object)this, (String)"HTTP status regex: %s\n", (Object[])new Object[]{p.pattern()});
        return m.matches();
    }
}

