/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.SocketUtils;
import org.opennms.netmgt.provision.detector.simple.client.MultilineOrientedClient;
import org.opennms.netmgt.provision.detector.simple.request.LineOrientedRequest;
import org.opennms.netmgt.provision.detector.simple.response.MultilineOrientedResponse;
import org.opennms.netmgt.provision.support.Client;

public class SSLClient
extends MultilineOrientedClient
implements Client<LineOrientedRequest, MultilineOrientedResponse> {
    @Override
    public void connect(InetAddress address, int port, int timeout) throws IOException {
        this.m_socket = this.getWrappedSocket(address, port, timeout);
        this.setOutput(this.m_socket.getOutputStream());
        this.setInput(new BufferedReader(new InputStreamReader(this.m_socket.getInputStream())));
    }

    protected Socket getWrappedSocket(InetAddress address, int port, int timeout) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(address, port), timeout);
        socket.setSoTimeout(timeout);
        try {
            return SocketUtils.wrapSocketInSslContext((Socket)socket);
        }
        catch (Exception e) {
            LogUtils.debugf((Object)this, (Throwable)e, (String)"Unable to wrap socket in SSL.", (Object[])new Object[0]);
            return null;
        }
    }
}

