/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.jmx;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.util.Collections;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.NameNotFoundException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionWrapper;
import org.opennms.netmgt.provision.DetectRequest;
import org.opennms.netmgt.provision.DetectResults;
import org.opennms.netmgt.provision.support.DetectResultsImpl;
import org.opennms.netmgt.provision.support.SyncAbstractDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JMXDetector
extends SyncAbstractDetector {
    private static final Logger LOG = LoggerFactory.getLogger(JMXDetector.class);
    private String m_object = null;

    protected JMXDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    protected JMXDetector(String serviceName, int port, int timeout, int retries) {
        super(serviceName, port, timeout, retries);
    }

    protected abstract JmxServerConnectionWrapper connect(InetAddress var1, int var2, int var3, Map<String, String> var4) throws ConnectException, IOException, MalformedURLException;

    public DetectResults detect(DetectRequest request) {
        return new DetectResultsImpl(this.isServiceDetected(request.getAddress(), request.getRuntimeAttributes()));
    }

    public final boolean isServiceDetected(InetAddress address) {
        return this.isServiceDetected(address, Collections.emptyMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isServiceDetected(InetAddress address, Map<String, String> runtimeAttributes) {
        String ipAddr = InetAddressUtils.str((InetAddress)address);
        int port = this.getPort();
        int retries = this.getRetries();
        int timeout = this.getTimeout();
        LOG.info("isServiceDetected: {}: Checking address: {} for capability on port {}", new Object[]{this.getServiceName(), ipAddr, port});
        int attempts = 0;
        while (attempts < retries) {
            try (JmxServerConnectionWrapper client = this.connect(address, port, timeout, runtimeAttributes);){
                LOG.info("isServiceDetected: {}: Attempting to connect to address: {}, port: {}, attempt: #{}", new Object[]{this.getServiceName(), ipAddr, port, attempts});
                if (client.getMBeanServerConnection().getMBeanCount() <= 0) {
                    boolean bl2 = false;
                    return bl2;
                }
                if (this.m_object != null) {
                    client.getMBeanServerConnection().getObjectInstance(new ObjectName(this.m_object));
                }
                boolean bl = true;
                return bl;
            }
            catch (ConnectException e) {
                LOG.info("isServiceDetected: {}: Unable to connect to address: {} port {}, attempt #{}", new Object[]{this.getServiceName(), ipAddr, port, attempts, e});
            }
            catch (NoRouteToHostException e) {
                LOG.info("isServiceDetected: {}: No route to address {} was available", new Object[]{this.getServiceName(), ipAddr, e});
            }
            catch (PortUnreachableException e) {
                LOG.info("isServiceDetected: {}: Port unreachable while connecting to address {} port {} within timeout: {} attempt: {}", new Object[]{this.getServiceName(), ipAddr, port, timeout, attempts, e});
            }
            catch (InterruptedIOException e) {
                LOG.info("isServiceDetected: {}: Did not connect to address {} port {} within timeout: {} attempt: {}", new Object[]{this.getServiceName(), ipAddr, port, timeout, attempts, e});
            }
            catch (MalformedObjectNameException e) {
                LOG.info("isServiceDetected: {}: Object instance {} is not valid on address {} port {} within timeout: {} attempt: {}", new Object[]{this.getServiceName(), this.m_object, ipAddr, port, timeout, attempts, e});
            }
            catch (InstanceNotFoundException e) {
                LOG.info("isServiceDetected: {}: Object instance {} does not exists on address {} port {} within timeout: {} attempt: {}", new Object[]{this.getServiceName(), this.m_object, ipAddr, port, timeout, attempts, e});
            }
            catch (IOException e) {
                boolean loggedIt = false;
                for (Throwable cause = e.getCause(); cause != null && !loggedIt; cause = cause.getCause()) {
                    if (cause instanceof ConnectException) {
                        LOG.info("isServiceDetected: {}: Unable to connect to address: {} port {}, attempt #{}", new Object[]{this.getServiceName(), ipAddr, port, attempts, e});
                        loggedIt = true;
                        continue;
                    }
                    if (cause instanceof NoRouteToHostException) {
                        LOG.info("isServiceDetected: {}: No route to address {} was available", new Object[]{this.getServiceName(), ipAddr, e});
                        loggedIt = true;
                        continue;
                    }
                    if (cause instanceof PortUnreachableException) {
                        LOG.info("isServiceDetected: {}: Port unreachable while connecting to address {} port {} within timeout: {} attempt: {}", new Object[]{this.getServiceName(), ipAddr, port, timeout, attempts, e});
                        loggedIt = true;
                        continue;
                    }
                    if (cause instanceof InterruptedIOException) {
                        LOG.info("isServiceDetected: {}: Did not connect to address {} port {} within timeout: {} attempt: {}", new Object[]{this.getServiceName(), ipAddr, port, timeout, attempts, e});
                        loggedIt = true;
                        continue;
                    }
                    if (cause instanceof NameNotFoundException) {
                        LOG.info("isServiceDetected: {}: Name {} not found on address {} port {} within timeout: {} attempt: {}", new Object[]{this.getServiceName(), this.m_object, ipAddr, port, timeout, attempts, e});
                        loggedIt = true;
                        continue;
                    }
                    if (cause instanceof MalformedObjectNameException) {
                        LOG.info("isServiceDetected: {}: Object instance {} is not valid on address {} port {} within timeout: {} attempt: {}", new Object[]{this.getServiceName(), this.m_object, ipAddr, port, timeout, attempts, e});
                        loggedIt = true;
                        continue;
                    }
                    if (!(cause instanceof InstanceNotFoundException)) continue;
                    LOG.info("isServiceDetected: {}: Object instance {} does not exists on address {} port {} within timeout: {} attempt: {}", new Object[]{this.getServiceName(), this.m_object, ipAddr, port, timeout, attempts, e});
                    loggedIt = true;
                }
                if (!loggedIt) {
                    LOG.error("isServiceDetected: {}: An unexpected I/O exception occured contacting address {} port {}", new Object[]{this.getServiceName(), ipAddr, port, e});
                }
            }
            catch (Throwable t) {
                LOG.error("isServiceDetected: {}: Unexpected error trying to detect {} on address {} port {}", new Object[]{this.getServiceName(), this.getServiceName(), ipAddr, port, t});
            }
            ++attempts;
        }
        return false;
    }

    protected void onInit() {
    }

    public void dispose() {
    }

    public String getObject() {
        return this.m_object;
    }

    public void setObject(String object) {
        this.m_object = object;
    }
}

