/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.jmx;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import org.opennms.netmgt.config.jmx.MBeanServer;
import org.opennms.netmgt.dao.jmx.JmxConfigDao;
import org.opennms.netmgt.jmx.connection.JmxConnectionConfig;
import org.opennms.netmgt.jmx.connection.JmxConnectionConfigBuilder;
import org.opennms.netmgt.provision.DetectRequest;
import org.opennms.netmgt.provision.detector.jmx.JMXDetector;
import org.opennms.netmgt.provision.support.DetectRequestImpl;
import org.opennms.netmgt.provision.support.GenericServiceDetectorFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GenericJMXDetectorFactory<T extends JMXDetector>
extends GenericServiceDetectorFactory<JMXDetector> {
    @Autowired(required=false)
    protected JmxConfigDao jmxConfigDao;

    public GenericJMXDetectorFactory(Class<T> clazz) {
        super(clazz);
    }

    public T createDetector() {
        return (T)((Object)((JMXDetector)super.createDetector()));
    }

    public DetectRequest buildRequest(String location, InetAddress address, Integer port, Map<String, String> attributes) {
        if (port == null && attributes.containsKey("url")) {
            try {
                JmxConnectionConfig config = JmxConnectionConfigBuilder.buildFrom((InetAddress)address, attributes).build();
                port = new JMXServiceURL(config.getUrl()).getPort();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("url is not valid", e);
            }
        }
        return new DetectRequestImpl(address, port, this.getRuntimeAttributes(address, port));
    }

    private Map<String, String> getRuntimeAttributes(InetAddress address, Integer port) {
        String ipAddress = address.getHostAddress();
        if (port == null) {
            throw new IllegalArgumentException(" Port number needs to be specified in the form of port=number ");
        }
        if (this.jmxConfigDao == null) {
            return Collections.emptyMap();
        }
        MBeanServer serverConfig = this.jmxConfigDao.getConfig().lookupMBeanServer(ipAddress, port.intValue());
        if (serverConfig == null) {
            return Collections.emptyMap();
        }
        return serverConfig.getParameterMap();
    }

    public void setJmxConfigDao(JmxConfigDao jmxConfigDao) {
        this.jmxConfigDao = jmxConfigDao;
    }
}

