/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support.jmx.connectors;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionWrapper;
import org.opennms.netmgt.provision.support.jmx.connectors.IsolatingClassLoader;
import org.opennms.netmgt.provision.support.jmx.connectors.JBossConnectionWrapper;
import org.opennms.netmgt.provision.support.protocol.jmx.MBeanServerProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JBossConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JBossConnectionFactory.class);
    static String[] packages = new String[]{"org.jboss.naming.*", "org.jboss.interfaces.*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static JmxServerConnectionWrapper getMBeanServerConnection(Map<String, Object> propertiesMap, InetAddress address) {
        JBossConnectionWrapper wrapper;
        block32: {
            wrapper = null;
            ClassLoader icl = null;
            ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
            String connectionType = ParameterMap.getKeyedString(propertiesMap, (String)"factory", (String)"RMI");
            String timeout = ParameterMap.getKeyedString(propertiesMap, (String)"timeout", (String)"3000");
            String jbossVersion = ParameterMap.getKeyedString(propertiesMap, (String)"version", (String)"4");
            String port = ParameterMap.getKeyedString(propertiesMap, (String)"port", (String)"1099");
            if (connectionType == null) {
                return null;
            }
            if (jbossVersion == null || jbossVersion.startsWith("4")) {
                icl = JBossConnectionFactory.createIsolatingClassloader(originalLoader, new File(System.getProperty("opennms.home") + "/lib/jboss/jbossall-client.jar"));
            } else if (jbossVersion.startsWith("3")) {
                icl = JBossConnectionFactory.createIsolatingClassloader(originalLoader, new File(System.getProperty("opennms.home") + "/lib/jboss/jbossall-client32.jar"));
            }
            if (icl == null) {
                return null;
            }
            Thread.currentThread().setContextClassLoader(icl);
            try {
                if (connectionType.equals("RMI")) {
                    InitialContext ctx = null;
                    try {
                        Hashtable<String, String> props = new Hashtable<String, String>();
                        props.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                        props.put("java.naming.provider.url", "jnp://" + InetAddressUtils.toUrlIpAddress((InetAddress)address) + ":" + port);
                        props.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                        props.put("jnp.sotimeout", timeout);
                        try {
                            ctx = new InitialContext(props);
                            Object rmiAdaptor = ctx.lookup("jmx/rmi/RMIAdaptor");
                            wrapper = new JBossConnectionWrapper(MBeanServerProxy.buildServerProxy(rmiAdaptor));
                        }
                        catch (Throwable t) {
                            LOG.debug("Unable to connect to JBOSS", t);
                        }
                        break block32;
                    }
                    finally {
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (Throwable props) {}
                    }
                }
                if (!connectionType.equals("HTTP")) break block32;
                InitialContext ctx = null;
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("java.naming.factory.initial", "org.jboss.naming.HttpNamingContextFactory");
                props.put("java.naming.provider.url", "http://" + InetAddressUtils.toUrlIpAddress((InetAddress)address) + ":" + port + "/invoker/JNDIFactory");
                props.put("jnp.sotimeout", timeout);
                ctx = new InitialContext(props);
                Object rmiAdaptor = ctx.lookup("jmx/rmi/RMIAdaptor");
                wrapper = new JBossConnectionWrapper(MBeanServerProxy.buildServerProxy(rmiAdaptor));
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block32;
                }
                catch (NamingException namingException) {}
                break block32;
                catch (Throwable throwable) {
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                        break block32;
                    }
                    catch (NamingException namingException) {}
                    break block32;
                    catch (Throwable throwable2) {
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException namingException) {
                            // empty catch block
                        }
                        throw throwable2;
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalLoader);
            }
        }
        return wrapper;
    }

    private static ClassLoader createIsolatingClassloader(final ClassLoader originalLoader, final File clientJar) {
        PrivilegedAction<ClassLoader> p = new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                try {
                    return new IsolatingClassLoader("jboss", new URL[]{clientJar.toURI().toURL()}, originalLoader, packages, true);
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IsolatingClassLoader.InvalidContextClassLoaderException invalidContextClassLoaderException) {
                    // empty catch block
                }
                return null;
            }
        };
        ClassLoader icl = AccessController.doPrivileged(p);
        return icl;
    }
}

