/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.jmx;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionWrapper;
import org.opennms.netmgt.jmx.impl.connection.connectors.Jsr160ConnectionFactory;
import org.opennms.netmgt.provision.detector.jmx.JMXDetector;

public abstract class AbstractJsr160Detector
extends JMXDetector {
    protected static int DEFAULT_PORT = 9003;
    private String m_factory = "STANDARD";
    private String m_friendlyName = "jsr160";
    private String m_protocol = "rmi";
    private String m_type = "default";
    private String m_urlPath = "/jmxrmi";
    private String m_username = "opennms";
    private String m_password = "OPENNMS";
    private String m_url;

    protected AbstractJsr160Detector(String serviceName, int port) {
        super(serviceName, port);
    }

    @Override
    protected JmxServerConnectionWrapper connect(InetAddress address, int port, int timeout, Map<String, String> runtimeAttributes) throws IOException {
        HashMap props = Maps.newHashMap();
        props.put("port", String.valueOf(port));
        props.put("timeout", String.valueOf(timeout));
        props.put("factory", this.getFactory());
        props.put("friendlyname", this.getFriendlyName());
        props.put("username", this.getUsername());
        props.put("password", this.getPassword());
        props.put("urlPath", this.getUrlPath());
        props.put("type", this.getType());
        props.put("protocol", this.getProtocol());
        props.put("url", this.getUrl());
        props.putAll(runtimeAttributes);
        return Jsr160ConnectionFactory.getMBeanServerConnection((Map)props, (InetAddress)address);
    }

    public void setFactory(String factory) {
        this.m_factory = factory;
    }

    public String getFactory() {
        return this.m_factory;
    }

    public void setFriendlyName(String friendlyName) {
        this.m_friendlyName = friendlyName;
    }

    public String getFriendlyName() {
        return this.m_friendlyName;
    }

    public void setProtocol(String protocol) {
        this.m_protocol = protocol;
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public String getType() {
        return this.m_type;
    }

    public void setUrlPath(String urlPath) {
        this.m_urlPath = urlPath;
    }

    public String getUrlPath() {
        return this.m_urlPath;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }
}

