/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.jdbc.client;

import java.io.IOException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.opennms.core.utils.DBTools;
import org.opennms.netmgt.provision.detector.jdbc.request.JDBCRequest;
import org.opennms.netmgt.provision.detector.jdbc.response.JDBCResponse;
import org.opennms.netmgt.provision.support.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCClient
implements Client<JDBCRequest, JDBCResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCClient.class);
    private String m_dbDriver;
    private String m_user;
    private String m_password;
    private String m_url;
    private Connection m_connection;

    public void close() {
        if (this.m_connection != null) {
            try {
                this.m_connection.close();
            }
            catch (SQLException e) {
                LOG.debug("unable to close JDBC connection", (Throwable)e);
            }
        }
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        LOG.info("connecting to JDBC on {}", (Object)address);
        LOG.debug("Loading JDBC driver: '{}'", (Object)this.getDbDriver());
        Driver driver = (Driver)Class.forName(this.getDbDriver()).newInstance();
        LOG.debug("JDBC driver loaded: '{}'", (Object)this.getDbDriver());
        String url = DBTools.constructUrl((String)this.getUrl(), (String)address.getCanonicalHostName());
        LOG.debug("Constructed JDBC url: '{}'", (Object)url);
        Properties props = new Properties();
        props.setProperty("user", this.getUser());
        props.setProperty("password", this.getPassword());
        props.setProperty("timeout", String.valueOf(timeout / 1000));
        this.m_connection = driver.connect(url, props);
        LOG.debug("Got database connection: '{}' ({}, {}, {})", new Object[]{this.m_connection, url, this.getUser(), this.getPassword()});
    }

    public JDBCResponse receiveBanner() throws IOException, Exception {
        JDBCResponse response = new JDBCResponse();
        response.receive(this.m_connection);
        return response;
    }

    public JDBCResponse sendRequest(JDBCRequest request) throws IOException, Exception {
        return request.send(this.m_connection);
    }

    public void setDbDriver(String dbDriver) {
        this.m_dbDriver = dbDriver;
    }

    public String getDbDriver() {
        return this.m_dbDriver;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    public String getUrl() {
        return this.m_url;
    }
}

