/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.features.reporting.model.LocalReports;
import org.opennms.features.reporting.model.Report;
import org.opennms.netmgt.dao.api.DatabaseReportConfigDao;

public class DefaultDatabaseReportConfigDao
extends AbstractJaxbConfigDao<LocalReports, List<Report>>
implements DatabaseReportConfigDao {
    public DefaultDatabaseReportConfigDao() {
        super(LocalReports.class, "Database Report Configuration");
    }

    public List<Report> translateConfig(LocalReports reports) {
        return Collections.unmodifiableList(reports.getReportList());
    }

    public String getReportService(String name) {
        Report report = this.getReport(name);
        if (report != null) {
            return report.getReportService();
        }
        return "";
    }

    public String getDisplayName(String name) {
        Report report = this.getReport(name);
        if (report != null) {
            return report.getDisplayName();
        }
        return "";
    }

    private Report getReport(String name) {
        for (Report report : (List)this.getContainer().getObject()) {
            if (!name.equals(report.getId())) continue;
            return report;
        }
        return null;
    }

    public List<Report> getReports() {
        return (List)this.getContainer().getObject();
    }

    public List<Report> getOnlineReports() {
        ArrayList<Report> onlineReports = new ArrayList<Report>();
        for (Report report : (List)this.getContainer().getObject()) {
            if (!report.isOnline().booleanValue()) continue;
            onlineReports.add(report);
        }
        return onlineReports;
    }
}

