/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.Serializable;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.api.PathOutageConfig;
import org.opennms.netmgt.dao.api.CriticalPath;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.MonitoringLocationUtils;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.dao.api.PathOutageDao;
import org.opennms.netmgt.dao.api.PathOutageManager;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsPathOutage;
import org.springframework.beans.factory.annotation.Autowired;

public class PathOutageManagerDaoImpl
implements PathOutageManager {
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private PathOutageDao pathOutageDao;
    @Autowired
    private MonitoredServiceDao monitoredServiceDao;
    @Autowired
    private OutageDao outageDao;
    @Autowired
    private PathOutageConfig pathOutageConfig;

    public static PathOutageManager getInstance() {
        return (PathOutageManager)BeanUtils.getBean((String)"daoContext", (String)"pathOutageManager", PathOutageManager.class);
    }

    public List<String[]> getAllCriticalPaths() throws SQLException {
        return this.pathOutageDao.getAllCriticalPaths();
    }

    public String getPrettyCriticalPath(int nodeID) {
        OnmsPathOutage out = (OnmsPathOutage)this.pathOutageDao.get((Serializable)Integer.valueOf(nodeID));
        if (out == null) {
            return "Not Configured";
        }
        return InetAddressUtils.str((InetAddress)out.getCriticalPathIp()) + " " + out.getCriticalPathServiceName();
    }

    public CriticalPath getCriticalPath(int nodeId) {
        OnmsPathOutage out;
        String location = null;
        InetAddress pathIp = this.pathOutageConfig.getDefaultCriticalPathIp();
        String serviceName = "ICMP";
        OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (node != null) {
            location = MonitoringLocationUtils.getLocationNameOrNullIfDefault((OnmsNode)node);
        }
        if ((out = (OnmsPathOutage)this.pathOutageDao.get((Serializable)Integer.valueOf(nodeId))) != null) {
            if (out.getCriticalPathIp() != null) {
                pathIp = out.getCriticalPathIp();
            }
            if (out.getCriticalPathServiceName() != null && !"".equals(out.getCriticalPathServiceName().trim())) {
                serviceName = out.getCriticalPathServiceName();
            }
        }
        return new CriticalPath(location, pathIp, serviceName);
    }

    public Set<Integer> getNodesInPath(String criticalPathIp, String criticalPathServiceName) {
        return new LinkedHashSet<Integer>(this.pathOutageDao.getNodesForPathOutage(InetAddressUtils.addr((String)criticalPathIp), criticalPathServiceName));
    }

    public String[] getLabelAndStatus(String nodeIDStr, Connection conn) {
        String[] result = new String[3];
        result[1] = "Cleared";
        result[2] = "Unmanaged";
        int nodeID = WebSecurityUtils.safeParseInt((String)nodeIDStr);
        OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(nodeID));
        if (node == null) {
            return result;
        }
        result[0] = node.getLabel();
        Criteria crit = new Criteria(OnmsMonitoredService.class).setAliases(Arrays.asList(new Alias("ipInterface", "ipInterface", Alias.JoinType.INNER_JOIN))).addRestriction((Restriction)new EqRestriction("status", (Object)"A")).addRestriction((Restriction)new EqRestriction("ipInterface.node", (Object)node));
        List services = this.monitoredServiceDao.findMatching(crit);
        int countManagedSvcs = services.size();
        int countOutages = 0;
        for (OnmsMonitoredService service : services) {
            OnmsOutage out = this.outageDao.currentOutageForService(service);
            if (out == null) continue;
            ++countOutages;
        }
        if (countManagedSvcs == countOutages) {
            result[1] = "Critical";
            result[2] = "All Services Down";
        } else if (countOutages == 0) {
            result[1] = "Normal";
            result[2] = "All Services Up";
        } else {
            result[1] = "Minor";
            result[2] = "Some Services Down";
        }
        return result;
    }

    public String[] getCriticalPathData(String criticalPathIp, String criticalPathServiceName) {
        OnmsOutage outage;
        OnmsNode node;
        String[] result = new String[4];
        List nList = this.nodeDao.findByIpAddressAndService(InetAddressUtils.addr((String)criticalPathIp), criticalPathServiceName);
        if (nList.size() < 1) {
            return result;
        }
        if (nList.size() == 1) {
            node = (OnmsNode)nList.get(0);
            result[0] = node.getLabel();
            result[1] = node.getNodeId();
        } else if (nList.size() > 1) {
            node = (OnmsNode)nList.get(0);
            result[0] = "(" + nList.size() + " nodes have this IP)";
            result[1] = node.getNodeId();
        }
        result[2] = String.valueOf(this.pathOutageDao.getNodesForPathOutage(InetAddressUtils.addr((String)criticalPathIp), criticalPathServiceName).size());
        OnmsMonitoredService service = this.monitoredServiceDao.get(Integer.valueOf(result[1]), InetAddressUtils.addr((String)criticalPathIp), criticalPathServiceName);
        result[3] = service != null ? ((outage = this.outageDao.currentOutageForService(service)) == null ? "Normal" : "Critical") : "Cleared";
        return result;
    }

    public Set<Integer> getAllNodesDependentOnAnyServiceOnInterface(String criticalPathip) {
        return new LinkedHashSet<Integer>(this.pathOutageDao.getAllNodesDependentOnAnyServiceOnInterface(InetAddressUtils.addr((String)criticalPathip)));
    }

    public Set<Integer> getAllNodesDependentOnAnyServiceOnNode(int nodeId) {
        return new LinkedHashSet<Integer>(this.pathOutageDao.getAllNodesDependentOnAnyServiceOnNode(nodeId));
    }

    public InetAddress getDefaultCriticalPathIp() {
        return this.pathOutageConfig.getDefaultCriticalPathIp();
    }
}

