/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.function.Supplier;
import org.hibernate.FlushMode;
import org.hibernate.SessionFactory;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionOperations;

public class DefaultSessionUtils
implements SessionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSessionUtils.class);
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private TransactionOperations transactionOperations;
    @Autowired
    private PlatformTransactionManager transactionManager;
    private static final DefaultTransactionDefinition readOnlyTransactionDefinition = new DefaultTransactionDefinition();

    public <V> V withTransaction(Supplier<V> supplier) {
        return (V)this.transactionOperations.execute(status -> supplier.get());
    }

    public <V> V withReadOnlyTransaction(Supplier<V> supplier) {
        return (V)this.executeWithTransactionDefinition((TransactionDefinition)readOnlyTransactionDefinition, () -> this.withManualFlush(supplier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V withManualFlush(Supplier<V> supplier) {
        FlushMode flushMode = this.sessionFactory.getCurrentSession().getFlushMode();
        try {
            this.sessionFactory.getCurrentSession().setFlushMode(FlushMode.MANUAL);
            V v = supplier.get();
            return v;
        }
        finally {
            this.sessionFactory.getCurrentSession().setFlushMode(flushMode);
        }
    }

    private <V> V executeWithTransactionDefinition(TransactionDefinition transactionDefinition, Supplier<V> supplier) {
        V result;
        TransactionStatus status = this.transactionManager.getTransaction(transactionDefinition);
        try {
            result = supplier.get();
        }
        catch (RuntimeException ex) {
            this.rollbackOnException(status, ex);
            throw ex;
        }
        catch (Error err) {
            this.rollbackOnException(status, err);
            throw err;
        }
        catch (Throwable ex) {
            this.rollbackOnException(status, ex);
            throw new UndeclaredThrowableException(ex, "TransactionCallback threw undeclared checked exception");
        }
        this.transactionManager.commit(status);
        return result;
    }

    private void rollbackOnException(TransactionStatus status, Throwable ex) throws TransactionException {
        LOG.debug("Initiating transaction rollback on application exception", ex);
        try {
            this.transactionManager.rollback(status);
        }
        catch (TransactionSystemException ex2) {
            LOG.error("Application exception overridden by rollback exception", ex);
            ex2.initApplicationException(ex);
            throw ex2;
        }
        catch (RuntimeException ex2) {
            LOG.error("Application exception overridden by rollback exception", ex);
            throw ex2;
        }
        catch (Error err) {
            LOG.error("Application exception overridden by rollback error", ex);
            throw err;
        }
    }

    static {
        readOnlyTransactionDefinition.setReadOnly(true);
    }
}

