/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.dao.support.InterfaceSnmpResourceType;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.ResourceTypeUtils;

public class InterfaceSnmpByIfIndexResourceType
implements OnmsResourceType {
    private final InterfaceSnmpResourceType m_interfaceSnmpResourceType;
    public static final String TYPE_NAME = "interfaceSnmpByIfIndex";

    protected InterfaceSnmpByIfIndexResourceType(InterfaceSnmpResourceType interfaceSnmpResourceType) {
        this.m_interfaceSnmpResourceType = Objects.requireNonNull(interfaceSnmpResourceType);
    }

    public String getName() {
        return TYPE_NAME;
    }

    public String getLabel() {
        return "SNMP Interface Data (by ifIndex)";
    }

    public String getLinkForResource(OnmsResource resource) {
        return this.m_interfaceSnmpResourceType.getLinkForResource(resource);
    }

    public boolean isResourceTypeOnParent(OnmsResource parent) {
        return false;
    }

    public List<OnmsResource> getResourcesForParent(OnmsResource parent) {
        return Collections.emptyList();
    }

    public OnmsResource getChildByName(OnmsResource parent, String name) {
        int ifIndex;
        OnmsNode node = ResourceTypeUtils.getNodeFromResource((OnmsResource)parent);
        OnmsSnmpInterface snmpInterface = node.getSnmpInterfaceWithIfIndex(ifIndex = Integer.parseInt(name));
        if (snmpInterface == null) {
            return null;
        }
        HashSet candidateInterfaceKeys = Sets.newHashSet();
        candidateInterfaceKeys.addAll(Arrays.asList(InterfaceSnmpResourceType.getKeysFor(snmpInterface)));
        Optional<String> path = this.m_interfaceSnmpResourceType.getQueryableInterfaces(parent).stream().filter(candidateInterfaceKeys::contains).findFirst();
        if (!path.isPresent()) {
            return null;
        }
        return this.m_interfaceSnmpResourceType.getChildByName(parent, path.get());
    }
}

