/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.hibernate.ObjectNotFoundException;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.dao.api.AlarmEntityNotifier;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.AckType;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.OnmsSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class AcknowledgmentDaoHibernate
extends AbstractDaoHibernate<OnmsAcknowledgment, Integer>
implements AcknowledgmentDao {
    private static final Logger LOG = LoggerFactory.getLogger(AcknowledgmentDaoHibernate.class);
    @Autowired
    private AlarmEntityNotifier alarmEntityNotifier;

    public AcknowledgmentDaoHibernate() {
        super(OnmsAcknowledgment.class);
    }

    public void updateAckable(Acknowledgeable ackable) {
        this.getHibernateTemplate().update((Object)ackable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Acknowledgeable> findAcknowledgables(OnmsAcknowledgment ack) {
        ArrayList<Acknowledgeable> ackables = new ArrayList<Acknowledgeable>();
        if (ack == null || ack.getAckType() == null) {
            return ackables;
        }
        if (ack.getAckType().equals((Object)AckType.ALARM)) {
            OnmsAlarm alarm = this.findAlarm(ack);
            try {
                if (alarm == null || alarm.getAckId() == null) return ackables;
                ackables.add((Acknowledgeable)alarm);
                List<OnmsNotification> notifs = this.findRelatedNotifications(alarm);
                if (notifs == null) return ackables;
                for (OnmsNotification notif : notifs) {
                    try {
                        if (notif.getAckId() == null) continue;
                        ackables.add((Acknowledgeable)notif);
                    }
                    catch (ObjectNotFoundException e) {
                        LOG.warn("found ackables for alarm #{} but ackable was invalid", (Object)ack.getRefId(), (Object)e);
                    }
                }
                return ackables;
            }
            catch (ObjectNotFoundException e) {
                LOG.warn("unable to find alarm with ID {}", (Object)ack.getRefId(), (Object)e);
                return ackables;
            }
        }
        if (!ack.getAckType().equals((Object)AckType.NOTIFICATION)) return ackables;
        OnmsNotification notif = this.findNotification(ack);
        try {
            if (notif == null || notif.getAckId() == null) return ackables;
            ackables.add((Acknowledgeable)notif);
            try {
                OnmsAlarm alarm;
                if (notif.getEvent() == null || (alarm = notif.getEvent().getAlarm()) == null) return ackables;
                ackables.add((Acknowledgeable)alarm);
                return ackables;
            }
            catch (ObjectNotFoundException e) {
                LOG.warn("unable to find alarm for notification #{}", (Object)notif.getNotifyId(), (Object)e);
            }
            return ackables;
        }
        catch (ObjectNotFoundException e) {
            LOG.warn("unable to find notification with ID {}", (Object)ack.getRefId(), (Object)e);
        }
        return ackables;
    }

    private List<OnmsNotification> findRelatedNotifications(OnmsAlarm alarm) {
        String hql = "from OnmsNotification as n where n.event.alarm = ?";
        return this.findObjects(OnmsNotification.class, "from OnmsNotification as n where n.event.alarm = ?", alarm);
    }

    private OnmsAlarm findAlarm(OnmsAcknowledgment ack) {
        try {
            if (ack != null) {
                return (OnmsAlarm)this.getHibernateTemplate().load(OnmsAlarm.class, (Serializable)ack.getRefId());
            }
        }
        catch (Exception e) {
            LOG.warn("unable to find alarm with ID {}", (Object)ack.getRefId(), (Object)e);
        }
        return null;
    }

    private OnmsNotification findNotification(OnmsAcknowledgment ack) {
        try {
            if (ack != null) {
                return (OnmsNotification)this.getHibernateTemplate().load(OnmsNotification.class, (Serializable)ack.getRefId());
            }
        }
        catch (Exception e) {
            LOG.warn("unable to find notification with ID {}", (Object)ack.getRefId(), (Object)e);
        }
        return null;
    }

    @Transactional(readOnly=false)
    public void processAcks(Collection<OnmsAcknowledgment> acks) {
        LOG.info("processAcks: Processing {} acknowledgements...", (Object)acks.size());
        for (OnmsAcknowledgment ack : acks) {
            this.processAck(ack);
        }
    }

    @Transactional(readOnly=false)
    public void processAck(OnmsAcknowledgment ack) {
        LOG.info("processAck: Searching DB for acknowledgables for ack: {}", (Object)ack);
        List<Acknowledgeable> ackables = this.findAcknowledgables(ack);
        if (ackables == null || ackables.size() < 1) {
            LOG.debug("processAck: No acknowledgables found.");
            throw new IllegalStateException("No acknowlegables in the database for ack: " + ack);
        }
        LOG.debug("processAck: Found {}. Acknowledging...", (Object)ackables.size());
        Iterator<Acknowledgeable> it = ackables.iterator();
        while (it.hasNext()) {
            try {
                Acknowledgeable ackable = it.next();
                boolean isAlarm = ackable instanceof OnmsAlarm;
                Consumer<OnmsAlarm> callback = null;
                switch (ack.getAckAction()) {
                    case ACKNOWLEDGE: {
                        Date ackTime;
                        String ackUser;
                        LOG.debug("processAck: Acknowledging ackable: {}...", (Object)ackable);
                        if (isAlarm) {
                            ackUser = ackable.getAckUser();
                            ackTime = ackable.getAckTime();
                            callback = alarm -> this.alarmEntityNotifier.didAcknowledgeAlarm(alarm, ackUser, ackTime);
                        }
                        ackable.acknowledge(ack.getAckUser());
                        LOG.debug("processAck: Acknowledged ackable: {}", (Object)ackable);
                        break;
                    }
                    case UNACKNOWLEDGE: {
                        Date ackTime;
                        String ackUser;
                        LOG.debug("processAck: Unacknowledging ackable: {}...", (Object)ackable);
                        if (isAlarm) {
                            ackUser = ackable.getAckUser();
                            ackTime = ackable.getAckTime();
                            callback = alarm -> this.alarmEntityNotifier.didUnacknowledgeAlarm(alarm, ackUser, ackTime);
                        }
                        ackable.unacknowledge(ack.getAckUser());
                        LOG.debug("processAck: Unacknowledged ackable: {}", (Object)ackable);
                        break;
                    }
                    case CLEAR: {
                        OnmsSeverity previousSeverity;
                        LOG.debug("processAck: Clearing ackable: {}...", (Object)ackable);
                        if (isAlarm) {
                            ((OnmsAlarm)ackable).getRelatedAlarms().forEach(relatedAlarm -> this.clearRelatedAlarm((OnmsAlarm)relatedAlarm));
                            previousSeverity = ackable.getSeverity();
                            callback = alarm -> this.alarmEntityNotifier.didUpdateAlarmSeverity(alarm, previousSeverity);
                        }
                        ackable.clear(ack.getAckUser());
                        LOG.debug("processAck: Cleared ackable: {}", (Object)ackable);
                        break;
                    }
                    case ESCALATE: {
                        OnmsSeverity previousSeverity;
                        LOG.debug("processAck: Escalating ackable: {}...", (Object)ackable);
                        if (isAlarm) {
                            previousSeverity = ackable.getSeverity();
                            callback = alarm -> this.alarmEntityNotifier.didUpdateAlarmSeverity(alarm, previousSeverity);
                        }
                        ackable.escalate(ack.getAckUser());
                        LOG.debug("processAck: Escalated ackable: {}", (Object)ackable);
                        break;
                    }
                }
                this.updateAckable(ackable);
                this.save(ack);
                this.flush();
                if (callback == null) continue;
                callback.accept((OnmsAlarm)ackable);
            }
            catch (Throwable t) {
                LOG.error("processAck: exception while processing: {}; {}", (Object)ack, (Object)t);
            }
        }
        LOG.info("processAck: Found and processed acknowledgables for the acknowledgement: {}", (Object)ack);
    }

    private void clearRelatedAlarm(OnmsAlarm alarm) {
        OnmsAcknowledgment clear = new OnmsAcknowledgment((Acknowledgeable)alarm);
        clear.setAckAction(AckAction.CLEAR);
        this.processAck(clear);
    }

    @Transactional
    public List<OnmsAcknowledgment> findLatestAcks() {
        String hqlQuery = "SELECT acks FROM OnmsAcknowledgment acks WHERE acks.ackTime = (SELECT MAX(filteredAcks.ackTime) FROM OnmsAcknowledgment filteredAcks WHERE filteredAcks.refId = acks.refId) AND acks.id = (SELECT MAX(filteredAcks.id) FROM OnmsAcknowledgment filteredAcks WHERE filteredAcks.refId = acks.refId)";
        return this.getHibernateTemplate().find(hqlQuery);
    }

    @Transactional
    public Optional<OnmsAcknowledgment> findLatestAckForRefId(Integer refId) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsAcknowledgment.class).eq("refId", (Object)refId).limit(Integer.valueOf(1)).orderBy("ackTime").desc().orderBy("id").desc();
        List acks = this.findMatching(builder.toCriteria());
        return acks.size() == 1 ? Optional.of(acks.get(0)) : Optional.empty();
    }
}

