/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.collections.LazyList;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.support.AbstractTopLevelResourceType;
import org.opennms.netmgt.dao.support.LazyChildResourceLoader;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.springframework.orm.ObjectRetrievalFailureException;

public final class NodeResourceType
extends AbstractTopLevelResourceType {
    public static final String RESOURCE_TYPE_NAME = "node";
    private static final Set<OnmsAttribute> s_emptyAttributeSet = Collections.unmodifiableSet(new HashSet());
    private final ResourceDao m_resourceDao;
    private final NodeDao m_nodeDao;

    public NodeResourceType(ResourceDao resourceDao, NodeDao nodeDao) {
        this.m_resourceDao = resourceDao;
        this.m_nodeDao = nodeDao;
    }

    public String getLabel() {
        return "Node";
    }

    public String getName() {
        return RESOURCE_TYPE_NAME;
    }

    public String getLinkForResource(OnmsResource resource) {
        return "element/node.jsp?node=" + resource.getName();
    }

    @Override
    public List<OnmsResource> getTopLevelResources() {
        return this.m_nodeDao.findAll().stream().filter(node -> node.getType() == null || !node.getType().equals((Object)"D")).map(this::createResourceForNode).collect(Collectors.toList());
    }

    @Override
    public OnmsResource getResourceByName(String nodeLookupCriteria) {
        OnmsNode node = this.m_nodeDao.get(nodeLookupCriteria);
        if (node == null) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)nodeLookupCriteria, "Top-level resource of resource type node could not be found: " + nodeLookupCriteria, null);
        }
        return this.createResourceForNode(node);
    }

    protected static ResourcePath getResourcePathForNode(OnmsNode node) {
        if (ResourceTypeUtils.isStoreByForeignSource() && node.getForeignSource() != null && node.getForeignId() != null) {
            return ResourcePath.get((String[])new String[]{"snmp", "fs", node.getForeignSource(), node.getForeignId()});
        }
        return ResourcePath.get((String[])new String[]{"snmp", Integer.toString(node.getId())});
    }

    protected OnmsResource createResourceForNode(OnmsNode node) {
        ResourcePath path = NodeResourceType.getResourcePathForNode(node);
        LazyChildResourceLoader loader = new LazyChildResourceLoader(this.m_resourceDao);
        String resourceName = node.getForeignSource() != null && node.getForeignId() != null ? String.format("%s:%s", node.getForeignSource(), node.getForeignId()) : Integer.toString(node.getId());
        OnmsResource resource = new OnmsResource(resourceName, node.getLabel(), (OnmsResourceType)this, s_emptyAttributeSet, (List)new LazyList((LazyList.Loader)loader), path);
        resource.setEntity((OnmsEntity)node);
        loader.setParent(resource);
        return resource;
    }

    public static boolean isNode(OnmsResource resource) {
        if (resource == null) {
            return false;
        }
        return resource.getResourceType() instanceof NodeResourceType;
    }
}

