/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opennms.core.utils.LazySet;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.netmgt.collection.api.StorageStrategy;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.LazyResourceAttributeLoader;
import org.opennms.netmgt.model.ExternalValueAttribute;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.StringPropertyAttribute;
import org.springframework.orm.ObjectRetrievalFailureException;

public final class GenericIndexResourceType
implements OnmsResourceType {
    private static final Pattern SUB_INDEX_PATTERN = Pattern.compile("^subIndex\\((.*)\\)$");
    private static final Pattern SUB_INDEX_ARGUMENTS_PATTERN = Pattern.compile("^(-?\\d+|n)(?:,\\s*(\\d+|n))?$");
    private static final Pattern HEX_PATTERN = Pattern.compile("^hex\\((.*)\\)$");
    private static final Pattern STRING_PATTERN = Pattern.compile("^string\\((.*)\\)$");
    private final String m_name;
    private final String m_label;
    private final String m_resourceLabelExpression;
    private final ResourceStorageDao m_resourceStorageDao;
    private final StorageStrategy m_storageStrategy;

    public GenericIndexResourceType(ResourceStorageDao resourceStorageDao, String name, String label, String resourceLabelExpression, StorageStrategy storageStrategy) {
        this.m_resourceStorageDao = resourceStorageDao;
        this.m_name = name;
        this.m_label = label;
        this.m_resourceLabelExpression = resourceLabelExpression;
        this.m_storageStrategy = storageStrategy;
    }

    public String getName() {
        return this.m_name;
    }

    public String getLabel() {
        return this.m_label;
    }

    public StorageStrategy getStorageStrategy() {
        return this.m_storageStrategy;
    }

    public boolean isResourceTypeOnParent(OnmsResource parent) {
        if (parent == null) {
            return false;
        }
        return this.m_resourceStorageDao.exists(new ResourcePath(parent.getPath(), new String[]{this.m_name}), 1);
    }

    public List<OnmsResource> getResourcesForParent(OnmsResource parent) {
        if (parent == null) {
            return Collections.emptyList();
        }
        ArrayList resources = Lists.newArrayList();
        List<String> indexes = this.getQueryableIndexes(new ResourcePath(parent.getPath(), new String[]{this.m_name}));
        for (String index : indexes) {
            resources.add(this.getResourceByPath(new ResourcePath(parent.getPath(), new String[]{this.m_name, index}), parent));
        }
        return OnmsResource.sortIntoResourceList((List)resources);
    }

    public OnmsResource getChildByName(OnmsResource parent, String index) {
        if (parent == null) {
            return null;
        }
        ResourcePath path = ResourcePath.get((ResourcePath)parent.getPath(), (String[])new String[]{this.getName(), index});
        if (!this.m_resourceStorageDao.exists(path, 0)) {
            throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)path, "Generic resource with label " + this.m_label + " could not find resource at path: " + path, null);
        }
        return this.getResourceByPath(path, parent);
    }

    public String getLinkForResource(OnmsResource resource) {
        return null;
    }

    private List<String> getQueryableIndexes(ResourcePath path) {
        return this.m_resourceStorageDao.children(path, 1).stream().map(rp -> rp.getName()).collect(Collectors.toList());
    }

    public OnmsResource getResourceByPath(ResourcePath path, OnmsResource parent) {
        String label;
        LazySet set = new LazySet((LazySet.Loader)new LazyResourceAttributeLoader(this.m_resourceStorageDao, path));
        final String index = path.getName();
        if (this.m_resourceLabelExpression == null) {
            label = index;
        } else {
            PropertiesUtils.SymbolTable symbolTable = new PropertiesUtils.SymbolTable((Set)set){
                private int lastN;
                private boolean lastNSet = false;
                final /* synthetic */ Set val$set;
                {
                    this.val$set = set;
                }

                public String getSymbolValue(String symbol) {
                    if (symbol.equals("index")) {
                        return index;
                    }
                    Matcher subIndexMatcher = SUB_INDEX_PATTERN.matcher(symbol);
                    if (subIndexMatcher.matches()) {
                        int end;
                        int start;
                        Matcher subIndexArgumentsMatcher = SUB_INDEX_ARGUMENTS_PATTERN.matcher(subIndexMatcher.group(1));
                        if (!subIndexArgumentsMatcher.matches()) {
                            return null;
                        }
                        List<String> indexElements = this.tokenizeIndex(index);
                        if ("n".equals(subIndexArgumentsMatcher.group(1)) && this.lastNSet) {
                            start = this.lastN;
                            this.lastNSet = false;
                        } else {
                            if ("n".equals(subIndexArgumentsMatcher.group(1))) {
                                return null;
                            }
                            int offset = Integer.parseInt(subIndexArgumentsMatcher.group(1));
                            start = offset < 0 ? indexElements.size() + offset : offset;
                        }
                        if ("n".equals(subIndexArgumentsMatcher.group(2))) {
                            end = start + Integer.parseInt(indexElements.get(start)) + 1;
                            ++start;
                            this.lastN = end;
                            this.lastNSet = true;
                        } else {
                            end = subIndexArgumentsMatcher.group(2) == null ? indexElements.size() : start + Integer.parseInt(subIndexArgumentsMatcher.group(2));
                        }
                        if (start < 0 || start >= indexElements.size()) {
                            return null;
                        }
                        if (end < 0 || end > indexElements.size()) {
                            return null;
                        }
                        StringBuilder indexSubString = new StringBuilder();
                        for (int i = start; i < end; ++i) {
                            if (indexSubString.length() != 0) {
                                indexSubString.append(".");
                            }
                            indexSubString.append(indexElements.get(i));
                        }
                        return indexSubString.toString();
                    }
                    Matcher hexMatcher = HEX_PATTERN.matcher(symbol);
                    if (hexMatcher.matches()) {
                        String subSymbol = this.getSymbolValue(hexMatcher.group(1));
                        List<String> indexElements = this.tokenizeIndex(subSymbol);
                        StringBuilder hexString = new StringBuilder();
                        for (String indexElement : indexElements) {
                            if (hexString.length() > 0) {
                                hexString.append(":");
                            }
                            try {
                                hexString.append(String.format("%02X", Integer.parseInt(indexElement)));
                            }
                            catch (NumberFormatException e) {
                                return null;
                            }
                        }
                        return hexString.toString();
                    }
                    Matcher stringMatcher = STRING_PATTERN.matcher(symbol);
                    if (stringMatcher.matches()) {
                        String subSymbol = this.getSymbolValue(stringMatcher.group(1));
                        List<String> indexElements = this.tokenizeIndex(subSymbol);
                        StringBuffer stringString = new StringBuffer();
                        for (String indexElement : indexElements) {
                            stringString.append(String.format("%c", Integer.parseInt(indexElement)));
                        }
                        return stringString.toString();
                    }
                    for (OnmsAttribute attr : this.val$set) {
                        if (!symbol.equals(attr.getName())) continue;
                        if (StringPropertyAttribute.class.isAssignableFrom(attr.getClass())) {
                            StringPropertyAttribute stringAttr = (StringPropertyAttribute)attr;
                            return stringAttr.getValue();
                        }
                        if (!ExternalValueAttribute.class.isAssignableFrom(attr.getClass())) continue;
                        ExternalValueAttribute extAttr = (ExternalValueAttribute)attr;
                        return extAttr.getValue();
                    }
                    return null;
                }

                private List<String> tokenizeIndex(String index2) {
                    ArrayList<String> indexElements = new ArrayList<String>();
                    StringTokenizer t = new StringTokenizer(index2, ".");
                    while (t.hasMoreTokens()) {
                        indexElements.add(t.nextToken());
                    }
                    return indexElements;
                }
            };
            label = PropertiesUtils.substitute((String)this.m_resourceLabelExpression, (PropertiesUtils.SymbolTable[])new PropertiesUtils.SymbolTable[]{symbolTable});
        }
        OnmsResource resource = new OnmsResource(index, label, (OnmsResourceType)this, (Set)set, path);
        resource.setParent(parent);
        return resource;
    }

    protected static Map<String, GenericIndexResourceType> createTypes(Map<String, ResourceType> configuredResourceTypes, ResourceStorageDao resourceStorageDao) {
        LinkedHashMap resourceTypes = Maps.newLinkedHashMap();
        LinkedList<ResourceType> resourceTypeList = new LinkedList<ResourceType>(configuredResourceTypes.values());
        Collections.sort(resourceTypeList, new Comparator<ResourceType>(){

            @Override
            public int compare(ResourceType r0, ResourceType r1) {
                Comparator comparator = (a, b) -> a.compareTo((String)b);
                return Objects.compare(r0.getLabel(), r1.getLabel(), Comparator.nullsLast(comparator));
            }
        });
        for (ResourceType resourceType : resourceTypeList) {
            StorageStrategy storageStrategy;
            Class<?> cinst;
            String className = resourceType.getStorageStrategy().getClazz();
            try {
                cinst = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not load class '" + className + "' for resource type '" + resourceType.getName() + "'", (Throwable)e);
            }
            try {
                storageStrategy = (StorageStrategy)cinst.newInstance();
            }
            catch (InstantiationException e) {
                throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not instantiate class '" + className + "' for resource type '" + resourceType.getName() + "'", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not instantiate class '" + className + "' for resource type '" + resourceType.getName() + "'", (Throwable)e);
            }
            storageStrategy.setResourceTypeName(resourceType.getName());
            GenericIndexResourceType genericIndexResourceType = new GenericIndexResourceType(resourceStorageDao, resourceType.getName(), resourceType.getLabel(), resourceType.getResourceLabel(), storageStrategy);
            resourceTypes.put(genericIndexResourceType.getName(), genericIndexResourceType);
        }
        return resourceTypes;
    }

    public String toString() {
        return "GenericIndexResourceType [name=" + this.m_name + ", label=" + this.m_label + ", resourceLabelExpression=" + this.m_resourceLabelExpression + ", resourceStorageDao=" + this.m_resourceStorageDao + ", storageStrategy=" + this.m_storageStrategy + "]";
    }
}

