/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import org.opennms.netmgt.dao.api.HwEntityDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsHwEntity;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public class HwEntityDaoHibernate
extends AbstractDaoHibernate<OnmsHwEntity, Integer>
implements HwEntityDao {
    public HwEntityDaoHibernate() {
        super(OnmsHwEntity.class);
    }

    public OnmsHwEntity findRootByNodeId(Integer nodeId) {
        return (OnmsHwEntity)this.findUnique("from OnmsHwEntity e where e.parent is null and e.node.id = ?", nodeId);
    }

    public OnmsHwEntity findEntityByIndex(Integer nodeId, Integer entPhysicalIndex) {
        return (OnmsHwEntity)this.findUnique("from OnmsHwEntity e where e.node.id = ? and e.entPhysicalIndex = ?", nodeId, entPhysicalIndex);
    }

    public OnmsHwEntity findEntityByName(Integer nodeId, String entPhysicalName) {
        return (OnmsHwEntity)this.findUnique("from OnmsHwEntity e where e.node.id = ? and e.entPhysicalName = ?", nodeId, entPhysicalName);
    }

    public String getAttributeValue(Integer nodeId, Integer entPhysicalIndex, String attributeName) {
        OnmsHwEntity e = this.findEntityByIndex(nodeId, entPhysicalIndex);
        return e == null ? null : this.getAttributeValue(e, attributeName);
    }

    public String getAttributeValue(Integer nodeId, String nameSource, String attributeName) {
        boolean isRegex = nameSource.startsWith("~");
        if (isRegex) {
            OnmsHwEntity r = this.findRootByNodeId(nodeId);
            return r == null ? null : this.findAttribute(r, nameSource.substring(1), attributeName);
        }
        OnmsHwEntity e = this.findEntityByName(nodeId, nameSource);
        return e == null ? null : this.getAttributeValue(e, attributeName);
    }

    private String findAttribute(OnmsHwEntity entity, String nameRegex, String attributeName) {
        if (entity.getEntPhysicalName().matches(nameRegex)) {
            return this.getAttributeValue(entity, attributeName);
        }
        for (OnmsHwEntity c : entity.getChildren()) {
            String v = this.findAttribute(c, nameRegex, attributeName);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private String getAttributeValue(OnmsHwEntity entity, String attributeName) {
        if (attributeName.startsWith("entPhysical")) {
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)entity);
            if (wrapper.isWritableProperty(attributeName)) {
                return (String)wrapper.getPropertyValue(attributeName);
            }
        } else {
            return entity.getAttributeValue(attributeName);
        }
        return null;
    }
}

