/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.opennms.netmgt.dao.api.TopologyEntityCache;
import org.opennms.netmgt.dao.api.TopologyEntityDao;
import org.opennms.netmgt.model.CdpElementTopologyEntity;
import org.opennms.netmgt.model.CdpLinkTopologyEntity;
import org.opennms.netmgt.model.IpInterfaceTopologyEntity;
import org.opennms.netmgt.model.IsIsElementTopologyEntity;
import org.opennms.netmgt.model.IsIsLinkTopologyEntity;
import org.opennms.netmgt.model.LldpElementTopologyEntity;
import org.opennms.netmgt.model.LldpLinkTopologyEntity;
import org.opennms.netmgt.model.NodeTopologyEntity;
import org.opennms.netmgt.model.OspfLinkTopologyEntity;
import org.opennms.netmgt.model.SnmpInterfaceTopologyEntity;

public class TopologyEntityCacheImpl
implements TopologyEntityCache {
    private static final String CACHE_KEY = "CACHE_KEY";
    private static final String SYSTEM_PROPERTY_CACHE_DURATION = "org.opennms.ui.topology-entity-cache-duration";
    private TopologyEntityDao topologyEntityDao;
    private final LoadingCache<String, List<NodeTopologyEntity>> nodeTopologyEntities = this.createCache(() -> this.topologyEntityDao.getNodeTopologyEntities());
    private final LoadingCache<String, List<CdpLinkTopologyEntity>> cdpLinkTopologyEntities = this.createCache(() -> this.topologyEntityDao.getCdpLinkTopologyEntities());
    private final LoadingCache<String, List<IsIsLinkTopologyEntity>> isIsLinkTopologyEntities = this.createCache(() -> this.topologyEntityDao.getIsIsLinkTopologyEntities());
    private final LoadingCache<String, List<OspfLinkTopologyEntity>> ospfLinkTopologyEntities = this.createCache(() -> this.topologyEntityDao.getOspfLinkTopologyEntities());
    private final LoadingCache<String, List<LldpLinkTopologyEntity>> lldpLinkTopologyEntities = this.createCache(() -> this.topologyEntityDao.getLldpLinkTopologyEntities());
    private final LoadingCache<String, List<CdpElementTopologyEntity>> cdpElementTopologyEntities = this.createCache(() -> this.topologyEntityDao.getCdpElementTopologyEntities());
    private final LoadingCache<String, List<IsIsElementTopologyEntity>> isIsElementTopologyEntities = this.createCache(() -> this.topologyEntityDao.getIsIsElementTopologyEntities());
    private final LoadingCache<String, List<LldpElementTopologyEntity>> lldpElementTopologyEntities = this.createCache(() -> this.topologyEntityDao.getLldpElementTopologyEntities());
    private final LoadingCache<String, List<SnmpInterfaceTopologyEntity>> snmpInterfaceTopologyEntities = this.createCache(() -> this.topologyEntityDao.getSnmpTopologyEntities());
    private final LoadingCache<String, List<IpInterfaceTopologyEntity>> ipInterfaceTopologyEntities = this.createCache(() -> this.topologyEntityDao.getIpTopologyEntities());

    private <KEY, VALUE> LoadingCache<KEY, VALUE> createCache(final Supplier<VALUE> entitySupplier) {
        CacheLoader loader = new CacheLoader<KEY, VALUE>(){

            public VALUE load(KEY key) {
                return entitySupplier.get();
            }
        };
        return CacheBuilder.newBuilder().expireAfterWrite((long)this.getCacheDuration(), TimeUnit.SECONDS).build(loader);
    }

    public List<NodeTopologyEntity> getNodeTopolgyEntities() {
        return (List)this.nodeTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    public List<CdpLinkTopologyEntity> getCdpLinkTopologyEntities() {
        return (List)this.cdpLinkTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    public List<OspfLinkTopologyEntity> getOspfLinkTopologyEntities() {
        return (List)this.ospfLinkTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    public List<IsIsLinkTopologyEntity> getIsIsLinkTopologyEntities() {
        return (List)this.isIsLinkTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    public List<LldpLinkTopologyEntity> getLldpLinkTopologyEntities() {
        return (List)this.lldpLinkTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    public List<CdpElementTopologyEntity> getCdpElementTopologyEntities() {
        return (List)this.cdpElementTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    public List<IsIsElementTopologyEntity> getIsIsElementTopologyEntities() {
        return (List)this.isIsElementTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    public List<LldpElementTopologyEntity> getLldpElementTopologyEntities() {
        return (List)this.lldpElementTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    public List<SnmpInterfaceTopologyEntity> getSnmpInterfaceTopologyEntities() {
        return (List)this.snmpInterfaceTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    public List<IpInterfaceTopologyEntity> getIpInterfaceTopologyEntities() {
        return (List)this.ipInterfaceTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    public void refresh() {
        this.nodeTopologyEntities.refresh((Object)CACHE_KEY);
        this.cdpLinkTopologyEntities.refresh((Object)CACHE_KEY);
        this.isIsLinkTopologyEntities.refresh((Object)CACHE_KEY);
        this.lldpLinkTopologyEntities.refresh((Object)CACHE_KEY);
        this.cdpElementTopologyEntities.refresh((Object)CACHE_KEY);
        this.isIsElementTopologyEntities.refresh((Object)CACHE_KEY);
        this.lldpElementTopologyEntities.refresh((Object)CACHE_KEY);
        this.snmpInterfaceTopologyEntities.refresh((Object)CACHE_KEY);
        this.ipInterfaceTopologyEntities.refresh((Object)CACHE_KEY);
    }

    private int getCacheDuration() {
        return Integer.getInteger(SYSTEM_PROPERTY_CACHE_DURATION, 300);
    }

    public void setTopologyEntityDao(TopologyEntityDao topologyEntityDao) {
        this.topologyEntityDao = topologyEntityDao;
    }
}

