/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.opennms.netmgt.dao.api.TopologyEntityCache;
import org.opennms.netmgt.dao.api.TopologyEntityDao;
import org.opennms.netmgt.model.CdpLinkTopologyEntity;
import org.opennms.netmgt.model.IsIsLinkTopologyEntity;
import org.opennms.netmgt.model.LldpLinkTopologyEntity;
import org.opennms.netmgt.model.NodeTopologyEntity;
import org.opennms.netmgt.model.OspfLinkTopologyEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyEntityCacheImpl
implements TopologyEntityCache {
    private static final Logger LOG = LoggerFactory.getLogger(TopologyEntityCacheImpl.class);
    private static final String CACHE_KEY = "CACHE_KEY";
    private static final String SYSTEM_PROPERTY_CACHE_DURATION = "org.opennms.ui.topology-entity-cache-duration";
    private TopologyEntityDao topologyEntityDao;
    private LoadingCache<String, List<NodeTopologyEntity>> nodeTopologyEntities = this.createCache(() -> this.topologyEntityDao.getNodeTopologyEntities());
    private LoadingCache<String, List<CdpLinkTopologyEntity>> cdpLinkTopologyEntities = this.createCache(() -> this.topologyEntityDao.getCdpLinkTopologyEntities());
    private LoadingCache<String, List<IsIsLinkTopologyEntity>> isIsLinkTopologyEntities = this.createCache(() -> this.topologyEntityDao.getIsIsLinkTopologyEntities());
    private LoadingCache<String, List<OspfLinkTopologyEntity>> ospfLinkTopologyEntities = this.createCache(() -> this.topologyEntityDao.getOspfLinkTopologyEntities());
    private LoadingCache<String, List<LldpLinkTopologyEntity>> lldpLinkTopologyEntities = this.createCache(() -> this.topologyEntityDao.getLldpLinkTopologyEntities());

    private <KEY, VALUE> LoadingCache<KEY, VALUE> createCache(final Supplier<VALUE> entitySupplier) {
        CacheLoader loader = new CacheLoader<KEY, VALUE>(){

            public VALUE load(KEY key) {
                return entitySupplier.get();
            }
        };
        return CacheBuilder.newBuilder().expireAfterWrite((long)this.getCacheDuration(), TimeUnit.SECONDS).build(loader);
    }

    public List<NodeTopologyEntity> getNodeTopolgyEntities() {
        return (List)this.nodeTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    public List<CdpLinkTopologyEntity> getCdpLinkTopologyEntities() {
        return (List)this.cdpLinkTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    public List<OspfLinkTopologyEntity> getOspfLinkTopologyEntities() {
        return (List)this.ospfLinkTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    public List<IsIsLinkTopologyEntity> getIsIsLinkTopologyEntities() {
        return (List)this.isIsLinkTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    public List<LldpLinkTopologyEntity> getLldpLinkTopologyEntities() {
        return (List)this.lldpLinkTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    public void refresh() {
        this.nodeTopologyEntities.refresh((Object)CACHE_KEY);
        this.cdpLinkTopologyEntities.refresh((Object)CACHE_KEY);
        this.nodeTopologyEntities.refresh((Object)CACHE_KEY);
        this.isIsLinkTopologyEntities.refresh((Object)CACHE_KEY);
        this.lldpLinkTopologyEntities.refresh((Object)CACHE_KEY);
    }

    private int getCacheDuration() {
        return Integer.getInteger(SYSTEM_PROPERTY_CACHE_DURATION, 300);
    }

    public void setTopologyEntityDao(TopologyEntityDao topologyEntityDao) {
        this.topologyEntityDao = topologyEntityDao;
    }
}

