/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.net.InetAddress;
import java.util.HashMap;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.AbstractInterfaceToNodeCache;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.dao.api.InterfaceToNodeMap;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class InterfaceToNodeCacheDaoImpl
extends AbstractInterfaceToNodeCache
implements InterfaceToNodeCache {
    private static final Logger LOG = LoggerFactory.getLogger(InterfaceToNodeCacheDaoImpl.class);
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    private final InterfaceToNodeMap m_knownips = new InterfaceToNodeMap();

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    @Transactional
    public void dataSourceSync() {
        HashMap<InterfaceToNodeMap.LocationIpAddressKey, Integer> newAlreadyDiscovered = new HashMap<InterfaceToNodeMap.LocationIpAddressKey, Integer>();
        CriteriaBuilder builder = new CriteriaBuilder(OnmsNode.class);
        builder.ne("type", (Object)String.valueOf(OnmsNode.NodeType.DELETED.value()));
        for (OnmsNode node : this.m_nodeDao.findMatching(builder.toCriteria())) {
            for (OnmsIpInterface iface : node.getIpInterfaces()) {
                if ("D".equals(iface.getIsManaged())) continue;
                LOG.debug("Adding entry: {}:{} -> {}", new Object[]{node.getLocation().getLocationName(), iface.getIpAddress(), node.getId()});
                newAlreadyDiscovered.put(new InterfaceToNodeMap.LocationIpAddressKey(node.getLocation().getLocationName(), iface.getIpAddress()), node.getId());
            }
        }
        this.m_knownips.setManagedAddresses(newAlreadyDiscovered);
        LOG.info("dataSourceSync: initialized list of managed IP addresses with {} members", (Object)this.m_knownips.size());
    }

    public synchronized int getNodeId(String location, InetAddress addr) {
        if (addr == null) {
            return -1;
        }
        return this.m_knownips.getNodeId(location, addr);
    }

    @Transactional
    public int setNodeId(String location, InetAddress addr, int nodeid) {
        if (addr == null || nodeid == -1) {
            return -1;
        }
        if (this.m_knownips.getNodeId(location, addr) < 1) {
            LOG.debug("setNodeId: adding IP address to cache: {}:{} -> {}", new Object[]{location, InetAddressUtils.str((InetAddress)addr), nodeid});
            return this.m_knownips.addManagedAddress(location, addr, nodeid);
        }
        OnmsIpInterface intf = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(Integer.valueOf(nodeid), InetAddressUtils.str((InetAddress)addr));
        if (intf != null && intf.isPrimary()) {
            LOG.info("setNodeId: updating SNMP primary IP address in cache: {}:{} -> {}", new Object[]{location, InetAddressUtils.str((InetAddress)addr), nodeid});
            return this.m_knownips.addManagedAddress(location, addr, nodeid);
        }
        LOG.debug("setNodeId: IP address {}:{} is not primary, avoiding cache update", (Object)location, (Object)InetAddressUtils.str((InetAddress)addr));
        return -1;
    }

    public int removeNodeId(String location, InetAddress addr) {
        if (addr == null) {
            LOG.warn("removeNodeId: null IP address");
            return -1;
        }
        LOG.debug("removeNodeId: removing IP address from cache: {}:{}", (Object)location, (Object)InetAddressUtils.str((InetAddress)addr));
        return this.m_knownips.removeManagedAddress(location, addr);
    }

    public int size() {
        return this.m_knownips.size();
    }

    public void clear() {
        this.m_knownips.setManagedAddresses(new HashMap());
    }
}

