/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.List;
import org.opennms.netmgt.dao.api.CdpElementDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.CdpElement;
import org.slf4j.LoggerFactory;

public class CdpElementDaoHibernate
extends AbstractDaoHibernate<CdpElement, Integer>
implements CdpElementDao {
    public CdpElementDaoHibernate() {
        super(CdpElement.class);
    }

    public CdpElement findByNodeId(Integer id) {
        return (CdpElement)this.findUnique("from CdpElement rec where rec.node.id = ?", id);
    }

    public CdpElement findByGlobalDeviceId(String deviceId) {
        List elements = this.find("from CdpElement rec where rec.cdpGlobalDeviceId = ? order by rec.id", deviceId);
        if (elements.size() > 1) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Expected 1 CdpElement for device with id '{}' but found {}. Using CdpElement {} and ignoring others.", new Object[]{deviceId, elements.size(), elements.get(0)});
        }
        return elements.isEmpty() ? null : (CdpElement)elements.get(0);
    }

    public void deleteByNodeId(Integer nodeId) {
        for (CdpElement rec : this.find("from CdpElement rec where rec.node.id = ? ", nodeId)) {
            this.delete(rec);
        }
    }
}

