/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.function.Supplier;
import org.opennms.netmgt.measurements.api.FetchResults;
import org.opennms.netmgt.measurements.api.MeasurementFetchStrategy;
import org.opennms.netmgt.measurements.model.Source;
import org.opennms.netmgt.model.AttributeStatisticVisitor;
import org.opennms.netmgt.model.AttributeVisitor;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class RrdStatisticAttributeVisitor
implements AttributeVisitor,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(RrdStatisticAttributeVisitor.class);
    private MeasurementFetchStrategy m_fetchStrategy;
    private String m_consolidationFunction;
    private Long m_startTime;
    private Long m_endTime;
    private AttributeStatisticVisitor m_statisticVisitor;

    public void visit(OnmsAttribute attribute) {
        FetchResults results;
        if (!RrdGraphAttribute.class.isAssignableFrom(attribute.getClass())) {
            return;
        }
        Source source = new Source();
        source.setLabel("result");
        source.setResourceId(attribute.getResource().getId());
        source.setAttribute(attribute.getName());
        source.setAggregation(this.m_consolidationFunction.toUpperCase());
        try {
            results = this.m_fetchStrategy.fetch(this.m_startTime.longValue(), this.m_endTime.longValue(), 1L, 0, null, null, Collections.singletonList(source), false);
        }
        catch (Exception e) {
            LOG.warn("Failed to fetch statistic: {}", (Object)source, (Object)e);
            return;
        }
        if (results == null) {
            LOG.warn("No statistic found: {}", (Object)source);
            return;
        }
        double[] statistics = (double[])results.getColumns().get(source.getLabel());
        if (statistics == null || statistics.length == 0) {
            LOG.warn("Statistic is empty: {}", (Object)source);
            return;
        }
        Aggregator aggregator = Aggregators.valueOf(this.m_consolidationFunction.toUpperCase()).get();
        Arrays.stream(statistics).filter(v -> !Double.isNaN(v)).forEach(v -> {
            LOG.debug("Aggregating: {}", (Object)v);
            aggregator.aggregate(v);
        });
        double statistic = aggregator.getValue();
        LOG.debug("The value of {} is {}", (Object)attribute, (Object)statistic);
        if (Double.isNaN(statistic)) {
            return;
        }
        this.m_statisticVisitor.visit(attribute, statistic);
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_fetchStrategy != null ? 1 : 0) != 0, (String)"property fetchStrategy must be set to a non-null value");
        Assert.state((this.m_consolidationFunction != null ? 1 : 0) != 0, (String)"property consolidationFunction must be set to a non-null value");
        Assert.state((this.m_startTime != null ? 1 : 0) != 0, (String)"property startTime must be set to a non-null value");
        Assert.state((this.m_endTime != null ? 1 : 0) != 0, (String)"property endTime must be set to a non-null value");
        Assert.state((this.m_statisticVisitor != null ? 1 : 0) != 0, (String)"property statisticVisitor must be set to a non-null value");
    }

    public MeasurementFetchStrategy getFetchStrategy() {
        return this.m_fetchStrategy;
    }

    public void setFetchStrategy(MeasurementFetchStrategy fetchStrategy) {
        this.m_fetchStrategy = fetchStrategy;
    }

    public AttributeStatisticVisitor getStatisticVisitor() {
        return this.m_statisticVisitor;
    }

    public void setStatisticVisitor(AttributeStatisticVisitor statisticVisitor) {
        this.m_statisticVisitor = statisticVisitor;
    }

    public String getConsolidationFunction() {
        return this.m_consolidationFunction;
    }

    public void setConsolidationFunction(String consolidationFunction) {
        this.m_consolidationFunction = consolidationFunction;
    }

    public Long getEndTime() {
        return this.m_endTime;
    }

    public void setEndTime(Long endTime) {
        this.m_endTime = endTime;
    }

    public Long getStartTime() {
        return this.m_startTime;
    }

    public void setStartTime(Long startTime) {
        this.m_startTime = startTime;
    }

    private static enum Aggregators implements Supplier<Aggregator>
    {
        AVERAGE(() -> new Aggregator(){
            private int count = 0;
            private double sum = 0.0;

            @Override
            public double getValue() {
                return this.count != 0 ? this.sum / (double)this.count : Double.NaN;
            }

            @Override
            public void aggregate(double v) {
                ++this.count;
                this.sum += v;
            }
        }),
        MIN(() -> new Aggregator(){
            private double min = Double.POSITIVE_INFINITY;

            @Override
            public double getValue() {
                return this.min;
            }

            @Override
            public void aggregate(double v) {
                this.min = Math.min(this.min, v);
            }
        }),
        MAX(() -> new Aggregator(){
            private double max = Double.NEGATIVE_INFINITY;

            @Override
            public double getValue() {
                return this.max;
            }

            @Override
            public void aggregate(double v) {
                this.max = Math.max(this.max, v);
            }
        }),
        LAST(() -> new Aggregator(){
            private double v = Double.NaN;

            @Override
            public double getValue() {
                return this.v;
            }

            @Override
            public void aggregate(double v) {
                this.v = v;
            }
        });

        private final Supplier<Aggregator> delegate;

        private Aggregators(Supplier<Aggregator> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Aggregator get() {
            return this.delegate.get();
        }
    }

    private static interface Aggregator {
        public double getValue();

        public void aggregate(double var1);
    }
}

