/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb.collector;

import java.io.File;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.datacollection.Collect;
import org.opennms.netmgt.config.datacollection.DatacollectionConfig;
import org.opennms.netmgt.config.datacollection.Group;
import org.opennms.netmgt.config.datacollection.Groups;
import org.opennms.netmgt.config.datacollection.IpList;
import org.opennms.netmgt.config.datacollection.MibObj;
import org.opennms.netmgt.config.datacollection.Rrd;
import org.opennms.netmgt.config.datacollection.SnmpCollection;
import org.opennms.netmgt.config.datacollection.SystemDef;
import org.opennms.netmgt.config.datacollection.SystemDefChoice;
import org.opennms.netmgt.config.datacollection.Systems;
import org.opennms.netmgt.dao.jaxb.collector.DataCollectionVisitor;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class DataCollectionConfigFile {
    File m_file;

    public DataCollectionConfigFile(File file) {
        this.m_file = file;
    }

    public void visit(DataCollectionVisitor visitor) {
        DatacollectionConfig dataCollectionConfig = this.getDataCollectionConfig();
        visitor.visitDataCollectionConfig(dataCollectionConfig);
        for (SnmpCollection snmpCollection : dataCollectionConfig.getSnmpCollections()) {
            this.doVisit(snmpCollection, visitor);
        }
        visitor.completeDataCollectionConfig(dataCollectionConfig);
    }

    private void doVisit(SnmpCollection snmpCollection, DataCollectionVisitor visitor) {
        visitor.visitSnmpCollection(snmpCollection);
        this.doVisit(snmpCollection.getRrd(), visitor);
        this.doVisit(snmpCollection.getSystems(), visitor);
        this.doVisit(snmpCollection.getGroups(), visitor);
        visitor.completeSnmpCollection(snmpCollection);
    }

    private void doVisit(Groups groups, DataCollectionVisitor visitor) {
        for (Group group : groups.getGroups()) {
            this.doVisit(group, visitor);
        }
    }

    private void doVisit(Group group, DataCollectionVisitor visitor) {
        visitor.visitGroup(group);
        for (MibObj mibObj : group.getMibObjs()) {
            this.doVisit(mibObj, visitor);
        }
        for (String subGroup : group.getIncludeGroups()) {
            this.doVisitSubGroup(subGroup, visitor);
        }
        visitor.completeGroup(group);
    }

    private void doVisitSubGroup(String subGroup, DataCollectionVisitor visitor) {
        visitor.visitSubGroup(subGroup);
        visitor.completeSubGroup(subGroup);
    }

    private void doVisit(MibObj mibObj, DataCollectionVisitor visitor) {
        visitor.visitMibObj(mibObj);
        visitor.completeMibObj(mibObj);
    }

    private void doVisit(Systems systems, DataCollectionVisitor visitor) {
        for (SystemDef systemDef : systems.getSystemDefs()) {
            this.doVisit(systemDef, visitor);
        }
    }

    private void doVisit(SystemDef systemDef, DataCollectionVisitor visitor) {
        visitor.visitSystemDef(systemDef);
        this.doVisit(systemDef.getSystemDefChoice(), visitor);
        this.doVisit(systemDef.getIpList(), visitor);
        this.doVisit(systemDef.getCollect(), visitor);
        visitor.completeSystemDef(systemDef);
    }

    private void doVisit(Collect collect, DataCollectionVisitor visitor) {
        visitor.visitCollect(collect);
        for (String includeGroup : collect.getIncludeGroups()) {
            this.doVisitIncludeGroup(includeGroup, visitor);
        }
        visitor.completeCollect(collect);
    }

    private void doVisitIncludeGroup(String includeGroup, DataCollectionVisitor visitor) {
        visitor.visitIncludeGroup(includeGroup);
        visitor.completeIncludeGroup(includeGroup);
    }

    private void doVisit(IpList ipList, DataCollectionVisitor visitor) {
        if (ipList == null) {
            return;
        }
        visitor.visitIpList(ipList);
        visitor.completeIpList(ipList);
    }

    private void doVisit(SystemDefChoice systemDefChoice, DataCollectionVisitor visitor) {
        if (systemDefChoice.getSysoid() != null) {
            this.doVisitSysOid(systemDefChoice.getSysoid(), visitor);
        }
        if (systemDefChoice.getSysoidMask() != null) {
            this.doVisitSysOidMask(systemDefChoice.getSysoidMask(), visitor);
        }
    }

    private void doVisitSysOidMask(String sysoidMask, DataCollectionVisitor visitor) {
        visitor.visitSysOidMask(sysoidMask);
        visitor.completeSysOidMask(sysoidMask);
    }

    private void doVisitSysOid(String sysoid, DataCollectionVisitor visitor) {
        visitor.visitSysOid(sysoid);
        visitor.completeSysOid(sysoid);
    }

    private void doVisit(Rrd rrd, DataCollectionVisitor visitor) {
        visitor.visitRrd(rrd);
        for (String rra : rrd.getRras()) {
            this.doVisitRra(rra, visitor);
        }
        visitor.completeRrd(rrd);
    }

    private void doVisitRra(String rra, DataCollectionVisitor visitor) {
        visitor.visitRra(rra);
        visitor.completeRra(rra);
    }

    private DatacollectionConfig getDataCollectionConfig() {
        return (DatacollectionConfig)JaxbUtils.unmarshal(DatacollectionConfig.class, (Resource)new FileSystemResource(this.m_file));
    }
}

