/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.siteStatusViews.View;
import org.opennms.netmgt.config.siteStatusViews.Views;
import org.opennms.netmgt.dao.api.SiteStatusViewConfigDao;
import org.opennms.netmgt.dao.castor.SiteStatusViewsFactory;
import org.springframework.dao.DataRetrievalFailureException;

public class DefaultSiteStatusViewConfigDao
implements SiteStatusViewConfigDao {
    public View getView(String viewName) {
        try {
            return SiteStatusViewsFactory.getInstance().getView(viewName);
        }
        catch (MarshalException e) {
            throw new DataRetrievalFailureException("Syntax error in site status view config file", (Throwable)e);
        }
        catch (ValidationException e) {
            throw new DataRetrievalFailureException("Syntax error in site status view config file", (Throwable)e);
        }
        catch (IOException e) {
            throw new DataRetrievalFailureException("Error load site status view config file", (Throwable)e);
        }
    }

    public Views getViews() {
        return SiteStatusViewsFactory.getConfig().getViews();
    }

    public Map<String, View> getViewMap() {
        return Collections.unmodifiableMap(SiteStatusViewsFactory.getViewsMap());
    }

    public View getDefaultView() {
        String defaultView = SiteStatusViewsFactory.getConfig().getDefaultView();
        return this.getView(defaultView);
    }

    static {
        try {
            SiteStatusViewsFactory.init();
        }
        catch (MarshalException e) {
            throw new DataRetrievalFailureException("Syntax error in site status view config file", (Throwable)e);
        }
        catch (ValidationException e) {
            throw new DataRetrievalFailureException("Syntax error in site status view config file", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new DataRetrievalFailureException("Unable to locate site status view config file", (Throwable)e);
        }
        catch (IOException e) {
            throw new DataRetrievalFailureException("Error load site status view config file", (Throwable)e);
        }
    }
}

