/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.opennms.core.utils.LazyList;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.AbstractTopLevelResourceType;
import org.opennms.netmgt.dao.support.LazyChildResourceLoader;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourcePath;
import org.springframework.orm.ObjectRetrievalFailureException;

public final class DomainResourceType
extends AbstractTopLevelResourceType {
    private static final Set<OnmsAttribute> s_emptyAttributeSet = Collections.unmodifiableSet(new HashSet());
    private final ResourceDao m_resourceDao;
    private final ResourceStorageDao m_resourceStorageDao;

    public DomainResourceType(ResourceDao resourceDao, ResourceStorageDao resourceStorageDao) {
        this.m_resourceDao = resourceDao;
        this.m_resourceStorageDao = resourceStorageDao;
    }

    public String getLabel() {
        return "Domain";
    }

    public String getName() {
        return "domain";
    }

    public String getLinkForResource(OnmsResource resource) {
        return null;
    }

    @Override
    public List<OnmsResource> getTopLevelResources() {
        return this.findDomainNames().stream().map(domain -> this.createResourceForDomain((String)domain)).collect(Collectors.toList());
    }

    @Override
    public OnmsResource getResourceByName(String domain) {
        if (!this.m_resourceStorageDao.exists(ResourcePath.get((String[])new String[]{"snmp", domain}), 1)) {
            throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)domain, "Top-level resource of type domain could not be found: " + domain, null);
        }
        return this.createResourceForDomain(domain);
    }

    private Set<String> findDomainNames() {
        TreeSet domainNames = Sets.newTreeSet();
        for (ResourcePath child : this.m_resourceStorageDao.children(ResourcePath.get((String[])new String[]{"snmp"}), 2)) {
            try {
                Integer.parseInt(child.getName());
            }
            catch (NumberFormatException e) {
                domainNames.add(child.getName());
            }
        }
        return domainNames;
    }

    private OnmsResource createResourceForDomain(String domain) {
        ResourcePath path = new ResourcePath(new String[]{"snmp", domain});
        LazyChildResourceLoader loader = new LazyChildResourceLoader(this.m_resourceDao);
        OnmsResource resource = new OnmsResource(domain, domain, (OnmsResourceType)this, s_emptyAttributeSet, (List)new LazyList((LazyList.Loader)loader), path);
        loader.setParent(resource);
        return resource;
    }

    public static boolean isDomain(OnmsResource resource) {
        return resource != null && resource.getResourceType() instanceof DomainResourceType;
    }
}

