/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.Serializable;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.NeRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.NodeLabel;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class NodeLabelDaoImpl
implements NodeLabel {
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private IpInterfaceDao ipInterfaceDao;
    private static final Logger LOG = LoggerFactory.getLogger(NodeLabelDaoImpl.class);
    private final String m_nodeLabel;
    private final OnmsNode.NodeLabelSource m_nodeLabelSource;

    public NodeLabelDaoImpl() {
        this.m_nodeLabel = null;
        this.m_nodeLabelSource = OnmsNode.NodeLabelSource.UNKNOWN;
    }

    public NodeLabelDaoImpl(String nodeLabel, OnmsNode.NodeLabelSource nodeLabelSource) {
        switch (nodeLabelSource) {
            case ADDRESS: 
            case HOSTNAME: 
            case NETBIOS: 
            case SYSNAME: 
            case UNKNOWN: 
            case USER: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for node label source: " + nodeLabelSource);
            }
        }
        this.m_nodeLabel = nodeLabel;
        this.m_nodeLabelSource = nodeLabelSource;
    }

    public String getLabel() {
        return this.m_nodeLabel;
    }

    public OnmsNode.NodeLabelSource getSource() {
        return this.m_nodeLabelSource;
    }

    public NodeLabel retrieveLabel(int nodeID) throws SQLException {
        OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(nodeID));
        String nodeLabel = node.getLabel();
        OnmsNode.NodeLabelSource nodeLabelSource = node.getLabelSource();
        return new NodeLabelDaoImpl(nodeLabel, nodeLabelSource);
    }

    @Transactional
    public void assignLabel(int nodeID, NodeLabel nodeLabel) throws SQLException {
        OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(nodeID));
        if (node == null) {
            LOG.warn("NodeLabel.assignLabel: Attemped to set node label on null node with ID {}", (Object)nodeID);
            return;
        }
        LOG.debug("NodeLabel.assignLabel: Node: {}, label: {}, source: {}", new Object[]{nodeID, nodeLabel.getLabel(), nodeLabel.getSource()});
        if (nodeLabel.getLabel() != null) {
            String label = nodeLabel.getLabel();
            if (label.length() > 256) {
                label = label.substring(0, 256);
            }
            node.setLabel(label);
        } else {
            node.setLabel(null);
        }
        node.setLabelSource(nodeLabel.getSource());
        this.nodeDao.update((Object)node);
    }

    public NodeLabel computeLabel(int nodeID) throws SQLException {
        OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(nodeID));
        if (node == null) {
            return null;
        }
        String netbiosName = node.getNetBiosName();
        if (netbiosName != null) {
            if (netbiosName.length() > 256) {
                netbiosName = netbiosName.substring(0, 256);
            }
            LOG.debug("NodeLabel.computeLabel: returning NetBIOS name as nodeLabel: {}", (Object)netbiosName);
            return new NodeLabelDaoImpl(netbiosName, OnmsNode.NodeLabelSource.NETBIOS);
        }
        String method = System.getProperty("org.opennms.bluebird.dp.primaryInterfaceSelectMethod");
        if (method == null) {
            method = "min";
        }
        if (!method.equals("min") && !method.equals("max")) {
            LOG.warn("Interface selection method is '{}'.  Valid values are 'min' & 'max'.  Will use default value: {}", (Object)method, (Object)"min");
            method = "min";
        }
        ArrayList<InetAddress> ipv4AddrList = new ArrayList<InetAddress>();
        ArrayList<String> ipHostNameList = new ArrayList<String>();
        Criteria criteria = new Criteria(OnmsIpInterface.class).setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN))).addRestriction((Restriction)new EqRestriction("node.id", (Object)nodeID)).addRestriction((Restriction)new EqRestriction("isManaged", (Object)"M"));
        List ints = this.ipInterfaceDao.findMatching(criteria);
        for (OnmsIpInterface iface : ints) {
            InetAddress inetAddr = iface.getIpAddress();
            ipv4AddrList.add(inetAddr);
            String hostName = iface.getIpHostName();
            if (hostName == null || hostName.equals(inetAddr.toString())) {
                ipHostNameList.add("");
                continue;
            }
            ipHostNameList.add(hostName);
        }
        InetAddress primaryAddr = NodeLabelDaoImpl.selectPrimaryAddress(ipv4AddrList, method);
        if (primaryAddr == null) {
            LOG.debug("NodeLabel.computeLabel: unable to find a primary address for node {}, returning null", (Object)nodeID);
            ipv4AddrList.clear();
            ipHostNameList.clear();
            Criteria crit = new Criteria(OnmsIpInterface.class).setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN))).addRestriction((Restriction)new EqRestriction("node.id", (Object)nodeID)).addRestriction((Restriction)new NeRestriction("isManaged", (Object)"M"));
            List sec = this.ipInterfaceDao.findMatching(crit);
            for (OnmsIpInterface iface : sec) {
                InetAddress inetAddr = iface.getIpAddress();
                ipv4AddrList.add(inetAddr);
                String hostName = iface.getIpHostName();
                if (hostName == null || hostName.equals(inetAddr.toString())) {
                    ipHostNameList.add("");
                    continue;
                }
                ipHostNameList.add(hostName);
            }
            primaryAddr = NodeLabelDaoImpl.selectPrimaryAddress(ipv4AddrList, method);
        }
        if (primaryAddr == null) {
            LOG.warn("Could not find primary interface for node {}, cannot compute nodelabel", (Object)nodeID);
            return new NodeLabelDaoImpl("Unknown", OnmsNode.NodeLabelSource.UNKNOWN);
        }
        int index = ipv4AddrList.indexOf(primaryAddr);
        String primaryHostName = (String)ipHostNameList.get(index);
        if (primaryHostName.length() != 0) {
            if (primaryHostName.length() > 256) {
                primaryHostName = primaryHostName.substring(0, 256);
            }
            return new NodeLabelDaoImpl(primaryHostName, OnmsNode.NodeLabelSource.HOSTNAME);
        }
        String primarySysName = node.getSysName();
        if (primarySysName != null && primarySysName.length() > 0) {
            if (primarySysName.length() > 256) {
                primarySysName = primarySysName.substring(0, 256);
            }
            return new NodeLabelDaoImpl(primarySysName, OnmsNode.NodeLabelSource.SYSNAME);
        }
        return new NodeLabelDaoImpl(InetAddressUtils.str((InetAddress)primaryAddr), OnmsNode.NodeLabelSource.ADDRESS);
    }

    private static InetAddress selectPrimaryAddress(List<InetAddress> ipv4AddrList, String method) {
        InetAddress primaryAddr = null;
        Iterator<InetAddress> iter = ipv4AddrList.iterator();
        while (iter.hasNext()) {
            if (primaryAddr == null) {
                primaryAddr = iter.next();
                continue;
            }
            InetAddress currentAddr = iter.next();
            byte[] current = currentAddr.getAddress();
            byte[] primary = primaryAddr.getAddress();
            if (method.equals("min")) {
                if (new ByteArrayComparator().compare(current, primary) >= 0) continue;
                primaryAddr = currentAddr;
                continue;
            }
            if (new ByteArrayComparator().compare(current, primary) <= 0) continue;
            primaryAddr = currentAddr;
        }
        return primaryAddr;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.m_nodeLabel);
        buffer.append(":");
        buffer.append(this.m_nodeLabelSource);
        return buffer.toString();
    }
}

