/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Date;
import java.util.List;
import org.opennms.netmgt.dao.api.LldpLinkDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.util.Assert;

public class LldpLinkDaoHibernate
extends AbstractDaoHibernate<LldpLink, Integer>
implements LldpLinkDao {
    public LldpLinkDaoHibernate() {
        super(LldpLink.class);
    }

    public LldpLink get(OnmsNode node, Integer lldpLocalPortNum) {
        return (LldpLink)this.findUnique("from LldpLink as lldpLink where lldpLink.node = ? and lldpLink.lldpLocalPortNum = ?", node, lldpLocalPortNum);
    }

    public LldpLink get(Integer nodeId, Integer lldpLocalPortNum) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        Assert.notNull((Object)lldpLocalPortNum, (String)"lldpLocalPortNum cannot be null");
        return (LldpLink)this.findUnique("from LldpLink as lldpLink where lldpLink.node.id = ? and lldpLink.lldpLocalPortNum = ?", nodeId, lldpLocalPortNum);
    }

    public List<LldpLink> findByNodeId(Integer nodeId) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        return this.find("from LldpLink lldpLink where lldpLink.node.id = ?", nodeId);
    }

    public void deleteByNodeIdOlderThen(Integer nodeId, Date now) {
        for (LldpLink link : this.find("from LldpLink lldpLink where lldpLink.node.id = ? and lldpLink.lldpLinkLastPollTime < ?", nodeId, now)) {
            this.delete(link);
        }
    }

    public void deleteByNodeId(Integer nodeId) {
        for (LldpLink link : this.find("from LldpLink lldpLink where lldpLink.node.id = ? ", nodeId)) {
            this.delete(link);
        }
    }

    public List<LldpLink> findLinksForIds(List<Integer> linkIds) {
        StringBuilder sql = new StringBuilder();
        sql.append("FROM LldpLink lldplink ");
        if (linkIds.size() == 1) {
            sql.append("where lldplink.id = " + linkIds.get(0) + " ");
        } else {
            sql.append("where lldplink.id in (");
            int counter = 0;
            for (Integer id : linkIds) {
                sql.append(id);
                if (counter < linkIds.size() - 1) {
                    sql.append(",");
                }
                ++counter;
            }
            sql.append(")");
        }
        return this.find(sql.toString());
    }
}

