/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.IfLabel;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.dao.util.AbstractIfLabel;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class IfLabelDaoImpl
extends AbstractIfLabel
implements IfLabel {
    private static final Logger LOG = LoggerFactory.getLogger(IfLabelDaoImpl.class);
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;

    public static IfLabel getInstance() {
        return (IfLabel)BeanUtils.getBean((String)"daoContext", (String)"ifLabel", IfLabel.class);
    }

    public Map<String, String> getInterfaceInfoFromIfLabel(int nodeId, String ifLabel) {
        if (ifLabel == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        HashMap<String, String> info = new HashMap<String, String>();
        String desc = ifLabel;
        String mac = null;
        int dashIndex = ifLabel.lastIndexOf(45);
        if (dashIndex >= 0) {
            desc = ifLabel.substring(0, dashIndex);
            mac = ifLabel.substring(dashIndex + 1, ifLabel.length());
        }
        String desc2 = desc;
        String mac2 = mac;
        LOG.debug("getInterfaceInfoFromIfLabel: desc={} mac={}", (Object)desc, mac);
        String queryDesc = desc.replace('_', '%');
        OnmsSnmpInterface iface = this.m_snmpInterfaceDao.findByNodeIdAndDescription(Integer.valueOf(nodeId), queryDesc);
        if (iface != null) {
            if (iface.getIfDescr() != null && Pattern.matches(".*-cef.*", iface.getIfDescr())) {
                return Collections.unmodifiableMap(info);
            }
            if ((AlphaNumeric.parseAndReplace((String)iface.getIfName(), (char)'_').equals(desc2) || AlphaNumeric.parseAndReplace((String)iface.getIfDescr(), (char)'_').equals(desc2)) && (mac2 == null || mac2.equals(iface.getPhysAddr()))) {
                info.put("id", String.valueOf(iface.getId()));
                info.put("nodeid", String.valueOf(iface.getNodeId()));
                info.put("snmpipadentnetmask", String.valueOf(iface.getNetMask()));
                info.put("snmpphysaddr", String.valueOf(iface.getPhysAddr()));
                info.put("snmpifindex", String.valueOf(iface.getIfIndex()));
                info.put("snmpifdescr", String.valueOf(iface.getIfDescr()));
                info.put("snmpiftype", String.valueOf(iface.getIfType()));
                info.put("snmpifname", String.valueOf(iface.getIfName()));
                info.put("snmpifspeed", String.valueOf(iface.getIfSpeed()));
                info.put("snmpifadminstatus", String.valueOf(iface.getIfAdminStatus()));
                info.put("snmpifoperstatus", String.valueOf(iface.getIfOperStatus()));
                info.put("snmpifalias", String.valueOf(iface.getIfAlias()));
                info.put("snmpcollect", String.valueOf(iface.getCollect()));
                info.put("snmplastcapsdpoll", String.valueOf(iface.getLastCapsdPoll()));
                info.put("snmppoll", String.valueOf(iface.getPoll()));
                info.put("snmplastsnmppoll", String.valueOf(iface.getLastSnmpPoll()));
            }
        }
        return Collections.unmodifiableMap(info);
    }

    public String getIfLabel(int nodeId, InetAddress ipAddr) {
        if (ipAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        CriteriaBuilder builder = new CriteriaBuilder(OnmsSnmpInterface.class);
        builder.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        builder.alias("ipInterfaces", "ipInterfaces", Alias.JoinType.LEFT_JOIN);
        builder.eq("node.id", (Object)nodeId);
        builder.ne("ipInterfaces.isManaged", (Object)"D");
        builder.eq("ipInterfaces.ipAddress", (Object)ipAddr);
        List ifaces = this.m_snmpInterfaceDao.findMatching(builder.toCriteria());
        if (ifaces.size() > 0) {
            if (ifaces.size() > 1) {
                LOG.warn("Found multiple OnmsSnmpInterface objects for: {}, {}, using the first entry", (Object)nodeId, (Object)InetAddressUtils.str((InetAddress)ipAddr));
            }
            OnmsSnmpInterface iface = (OnmsSnmpInterface)ifaces.iterator().next();
            String name = iface.getIfName();
            String descr = iface.getIfDescr();
            String physAddr = iface.getPhysAddr();
            if (name != null || descr != null) {
                return this.getIfLabel(name, descr, physAddr);
            }
            LOG.warn("Interface (nodeId/ipAddr={}/{}) has no ifName and no ifDescr...setting to label to '{}'.", new Object[]{nodeId, InetAddressUtils.str((InetAddress)ipAddr), "no_ifLabel"});
            return "no_ifLabel";
        }
        LOG.warn("No OnmsSnmpInterface found for: {}, {}; setting to label to '{}'", new Object[]{nodeId, InetAddressUtils.str((InetAddress)ipAddr), "no_ifLabel"});
        return "no_ifLabel";
    }

    public String getIfLabelfromIfIndex(int nodeId, InetAddress ipAddr, int ifIndex) {
        if (ipAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (ifIndex == -1) {
            return this.getIfLabel(nodeId, ipAddr);
        }
        CriteriaBuilder builder = new CriteriaBuilder(OnmsSnmpInterface.class);
        builder.alias("ipInterfaces", "ipInterfaces", Alias.JoinType.LEFT_JOIN);
        builder.alias("ipInterfaces.node", "node", Alias.JoinType.LEFT_JOIN);
        builder.eq("ifIndex", (Object)ifIndex);
        builder.eq("node.id", (Object)nodeId);
        builder.ne("ipInterfaces.isManaged", (Object)"D");
        builder.eq("ipInterfaces.ipAddress", (Object)ipAddr);
        List ifaces = this.m_snmpInterfaceDao.findMatching(builder.toCriteria());
        if (ifaces.size() > 0) {
            if (ifaces.size() > 1) {
                LOG.warn("Found multiple OnmsSnmpInterface objects for: {}, {}, {}, using the first entry", new Object[]{nodeId, InetAddressUtils.str((InetAddress)ipAddr), ifIndex});
            }
            OnmsSnmpInterface iface = (OnmsSnmpInterface)ifaces.iterator().next();
            String name = iface.getIfName();
            String descr = iface.getIfDescr();
            String physAddr = iface.getPhysAddr();
            if (name != null || descr != null) {
                return this.getIfLabel(name, descr, physAddr);
            }
            LOG.warn("Interface (nodeId/ipAddr={}/{}) has no ifName and no ifDescr...setting to label to '{}'.", new Object[]{nodeId, InetAddressUtils.str((InetAddress)ipAddr), "no_ifLabel"});
            return "no_ifLabel";
        }
        LOG.warn("No OnmsSnmpInterface found for: {}, {}, {}, using node ID and IP address only", new Object[]{nodeId, InetAddressUtils.str((InetAddress)ipAddr), ifIndex});
        return this.getIfLabel(nodeId, ipAddr);
    }

    public String getIfLabelfromSnmpIfIndex(int nodeId, int ifIndex) {
        OnmsSnmpInterface iface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(nodeId), Integer.valueOf(ifIndex));
        String name = iface.getIfName();
        String descr = iface.getIfDescr();
        String physAddr = iface.getPhysAddr();
        if (name != null || descr != null) {
            return this.getIfLabel(name, descr, physAddr);
        }
        LOG.warn("Interface (nodeId/ifIndex={}/{}) has no ifName and no ifDescr...setting to label to '{}'.", new Object[]{nodeId, ifIndex, "no_ifLabel"});
        return "no_ifLabel";
    }
}

