/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsEvent;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;

public class EventDaoHibernate
extends AbstractDaoHibernate<OnmsEvent, Integer>
implements EventDao {
    public EventDaoHibernate() {
        super(OnmsEvent.class);
    }

    public int deletePreviousEventsForAlarm(Integer id, OnmsEvent e) throws DataAccessException {
        String hql = "delete from OnmsEvent where alarmid = ? and eventid != ?";
        Object[] values = new Object[]{id, e.getId()};
        return this.bulkDelete(hql, values);
    }

    public List<OnmsEvent> getEventsAfterDate(final List<String> ueiList, final Date date) {
        String hql = "From OnmsEvent e where e.eventUei in (:eventUei) and e.eventTime > :eventTime order by e.eventTime desc";
        return this.getHibernateTemplate().executeFind((HibernateCallback)new HibernateCallback<List<OnmsEvent>>(){

            public List<OnmsEvent> doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createQuery("From OnmsEvent e where e.eventUei in (:eventUei) and e.eventTime > :eventTime order by e.eventTime desc").setParameterList("eventUei", (Collection)ueiList).setParameter("eventTime", (Object)date).list();
            }
        });
    }
}

