/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.model.HeatMapElement;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(dirtiesContext=false)
public class HeatMapIT
implements InitializingBean {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private AlarmDao m_alarmDao;
    @Autowired
    private OutageDao m_outageDao;
    @Autowired
    private CategoryDao m_categoryDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;
    private static boolean m_populated = false;
    private Map<String, Integer> numberOfNodesInCategory;

    @BeforeTransaction
    public void setUp() {
        if (!m_populated) {
            this.m_databasePopulator.populateDatabase();
            m_populated = true;
        }
        this.numberOfNodesInCategory = new HashMap<String, Integer>();
        List onmsCategories = this.m_categoryDao.findAll();
        for (OnmsCategory onmsCategory : onmsCategories) {
            int n = this.m_nodeDao.findByCategory(onmsCategory).size();
            if (n <= 0) continue;
            this.numberOfNodesInCategory.put(onmsCategory.getName(), n);
        }
    }

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Test
    @Transactional
    public void testOutagesForTestDB() {
        List heatMapElements = this.m_outageDao.getHeatMapItemsForEntity("categories.categoryname", "categories.categoryid", null, null, new String[0]);
        Assert.assertEquals((int)this.numberOfNodesInCategory.size(), (int)heatMapElements.size());
        for (HeatMapElement heatMapElement : heatMapElements) {
            Assert.assertEquals((int)this.numberOfNodesInCategory.get(heatMapElement.getName()), (int)heatMapElement.getNodesTotal());
        }
    }

    @Test
    @Transactional
    public void testAlarmsForTestDB() {
        List heatMapElements = this.m_alarmDao.getHeatMapItemsForEntity("categories.categoryname", "categories.categoryid", true, null, null, new String[0]);
        Assert.assertEquals((int)this.numberOfNodesInCategory.size(), (int)heatMapElements.size());
        for (HeatMapElement heatMapElement : heatMapElements) {
            Assert.assertEquals((int)this.numberOfNodesInCategory.get(heatMapElement.getName()), (int)heatMapElement.getNodesTotal());
        }
    }
}

