/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.Order;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsMonitoringSystem;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.alarm.AlarmSummary;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.ThrowableAnticipator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(dirtiesContext=false)
public class AlarmDaoIT
implements InitializingBean {
    @Autowired
    private DistPollerDao m_distPollerDao;
    @Autowired
    private EventDao m_eventDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private AlarmDao m_alarmDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;
    private static boolean m_populated = false;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @BeforeTransaction
    public void setUp() {
        if (!m_populated) {
            this.m_databasePopulator.populateDatabase();
            m_populated = true;
        }
    }

    @Test
    @Transactional
    public void testActions() {
        OnmsEvent event = new OnmsEvent();
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        event.setEventCreateTime(new Date());
        event.setDistPoller((OnmsMonitoringSystem)this.m_distPollerDao.whoami());
        event.setEventTime(new Date());
        event.setEventSeverity(Integer.valueOf(6));
        event.setEventUei("uei://org/opennms/test/EventDaoTest");
        event.setEventSource("test");
        this.m_eventDao.save((Object)event);
        OnmsNode node = (OnmsNode)this.m_nodeDao.findAll().iterator().next();
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setNode(node);
        alarm.setUei(event.getEventUei());
        alarm.setSeverity(OnmsSeverity.get((int)event.getEventSeverity()));
        alarm.setSeverityId(event.getEventSeverity());
        alarm.setFirstEventTime(event.getEventTime());
        alarm.setLastEvent(event);
        alarm.setCounter(Integer.valueOf(1));
        alarm.setDistPoller((OnmsMonitoringSystem)this.m_distPollerDao.whoami());
        this.m_alarmDao.save((Object)alarm);
        OnmsAlarm newAlarm = (OnmsAlarm)this.m_alarmDao.load((Serializable)alarm.getId());
        Assert.assertEquals((Object)"uei://org/opennms/test/EventDaoTest", (Object)newAlarm.getUei());
        Assert.assertEquals((Object)alarm.getLastEvent().getId(), (Object)newAlarm.getLastEvent().getId());
        Assert.assertEquals((Object)OnmsSeverity.MAJOR, (Object)newAlarm.getSeverity());
        newAlarm.escalate("admin");
        Assert.assertEquals((Object)OnmsSeverity.CRITICAL, (Object)newAlarm.getSeverity());
        newAlarm.clear("admin");
        Assert.assertEquals((Object)OnmsSeverity.CLEARED, (Object)newAlarm.getSeverity());
        newAlarm.unacknowledge("admin");
        Assert.assertNull((Object)newAlarm.getAckUser());
        Assert.assertNull((Object)newAlarm.getAlarmAckTime());
    }

    @Test
    @Transactional
    public void testSave() {
        OnmsEvent event = new OnmsEvent();
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        event.setEventCreateTime(new Date());
        event.setDistPoller((OnmsMonitoringSystem)this.m_distPollerDao.whoami());
        event.setEventTime(new Date());
        event.setEventSeverity(new Integer(7));
        event.setEventUei("uei://org/opennms/test/EventDaoTest");
        event.setEventSource("test");
        this.m_eventDao.save((Object)event);
        OnmsNode node = (OnmsNode)this.m_nodeDao.findAll().iterator().next();
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setNode(node);
        alarm.setUei(event.getEventUei());
        alarm.setSeverityId(event.getEventSeverity());
        alarm.setFirstEventTime(event.getEventTime());
        alarm.setLastEvent(event);
        alarm.setCounter(Integer.valueOf(1));
        alarm.setDistPoller((OnmsMonitoringSystem)this.m_distPollerDao.whoami());
        this.m_alarmDao.save((Object)alarm);
        OnmsAlarm newAlarm = (OnmsAlarm)this.m_alarmDao.load((Serializable)alarm.getId());
        Assert.assertEquals((Object)"uei://org/opennms/test/EventDaoTest", (Object)newAlarm.getUei());
        Assert.assertEquals((Object)alarm.getLastEvent().getId(), (Object)newAlarm.getLastEvent().getId());
        Criteria criteria = new Criteria(OnmsAlarm.class);
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)node.getId()));
        List alarms = this.m_alarmDao.findMatching(criteria);
        Assert.assertEquals((long)1L, (long)alarms.size());
        newAlarm = (OnmsAlarm)alarms.iterator().next();
        Assert.assertEquals((Object)"uei://org/opennms/test/EventDaoTest", (Object)newAlarm.getUei());
        Assert.assertEquals((Object)alarm.getLastEvent().getId(), (Object)newAlarm.getLastEvent().getId());
    }

    @Test
    @Transactional
    @Ignore
    public void testWithoutDistPoller() {
        OnmsEvent event = new OnmsEvent();
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        event.setEventCreateTime(new Date());
        event.setDistPoller((OnmsMonitoringSystem)this.m_distPollerDao.whoami());
        event.setEventTime(new Date());
        event.setEventSeverity(new Integer(7));
        event.setEventUei("uei://org/opennms/test/EventDaoTest");
        event.setEventSource("test");
        this.m_eventDao.save((Object)event);
        OnmsNode node = (OnmsNode)this.m_nodeDao.findAll().iterator().next();
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setNode(node);
        alarm.setUei(event.getEventUei());
        alarm.setSeverityId(event.getEventSeverity());
        alarm.setFirstEventTime(event.getEventTime());
        alarm.setLastEvent(event);
        alarm.setCounter(Integer.valueOf(1));
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new DataIntegrityViolationException("not-null property references a null or transient value: org.opennms.netmgt.model.OnmsAlarm.distPoller; nested exception is org.hibernate.PropertyValueException: not-null property references a null or transient value: org.opennms.netmgt.model.OnmsAlarm.distPoller"));
        try {
            this.m_alarmDao.save((Object)alarm);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    @Transactional
    public void testAlarmSummary() {
        OnmsEvent event = new OnmsEvent();
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        event.setEventCreateTime(new Date());
        event.setDistPoller((OnmsMonitoringSystem)this.m_distPollerDao.whoami());
        event.setEventTime(new Date());
        event.setEventSeverity(new Integer(7));
        event.setEventUei("uei://org/opennms/test/EventDaoTest");
        event.setEventSource("test");
        this.m_eventDao.save((Object)event);
        OnmsNode node = (OnmsNode)this.m_nodeDao.findAll().iterator().next();
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setNode(node);
        alarm.setUei(event.getEventUei());
        alarm.setSeverityId(event.getEventSeverity());
        alarm.setFirstEventTime(event.getEventTime());
        alarm.setLastEvent(event);
        alarm.setCounter(Integer.valueOf(1));
        alarm.setDistPoller((OnmsMonitoringSystem)this.m_distPollerDao.whoami());
        this.m_alarmDao.save((Object)alarm);
        List summary = this.m_alarmDao.getNodeAlarmSummaries();
        Assert.assertNotNull((Object)summary);
        Assert.assertEquals((long)1L, (long)summary.size());
        AlarmSummary sum = (AlarmSummary)summary.get(0);
        Assert.assertEquals((Object)node.getLabel(), (Object)sum.getNodeLabel());
        Assert.assertEquals((long)alarm.getSeverity().getId(), (long)sum.getMaxSeverity().getId());
        Assert.assertNotSame((Object)"N/A", (Object)sum.getFuzzyTimeDown());
    }

    @Test
    @Transactional
    public void testAlarmSummary_WithEmptyNodeIdsArray() {
        List summary = this.m_alarmDao.getNodeAlarmSummaries();
        Assert.assertNotNull((Object)summary);
        summary = null;
        summary = this.m_alarmDao.getNodeAlarmSummaries();
        Assert.assertNotNull((Object)summary);
    }

    @Test
    @Transactional
    public void testAlarmSummary_AlarmWithNoEvent() {
        OnmsNode node = (OnmsNode)this.m_nodeDao.findAll().iterator().next();
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setNode(node);
        alarm.setUei("uei://org/opennms/test/badAlarmTest");
        alarm.setSeverityId(new Integer(7));
        alarm.setCounter(Integer.valueOf(1));
        alarm.setDistPoller((OnmsMonitoringSystem)this.m_distPollerDao.whoami());
        this.m_alarmDao.save((Object)alarm);
        List summary = this.m_alarmDao.getNodeAlarmSummaries();
        Assert.assertNotNull((Object)summary);
        Assert.assertEquals((long)1L, (long)summary.size());
        AlarmSummary sum = (AlarmSummary)summary.get(0);
        Assert.assertEquals((Object)node.getLabel(), (Object)sum.getNodeLabel());
        Assert.assertEquals((long)alarm.getSeverity().getId(), (long)sum.getMaxSeverity().getId());
        Assert.assertEquals((Object)"N/A", (Object)sum.getFuzzyTimeDown());
    }

    @Test
    @Transactional
    public void testSortOnNodeLabel() {
        Criteria criteria = new Criteria(OnmsAlarm.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.setOrders(Arrays.asList(Order.asc((String)"node.label")));
        this.m_alarmDao.findMatching(criteria);
    }
}

