/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Date;
import java.util.List;
import org.opennms.netmgt.dao.api.BridgeElementDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.BridgeElement;

public class BridgeElementDaoHibernate
extends AbstractDaoHibernate<BridgeElement, Integer>
implements BridgeElementDao {
    public BridgeElementDaoHibernate() {
        super(BridgeElement.class);
    }

    public List<BridgeElement> findByNodeId(Integer id) {
        return this.find("from BridgeElement rec where rec.node.id = ?", id);
    }

    public BridgeElement getByNodeIdVlan(Integer id, Integer vlanId) {
        if (vlanId == null) {
            return (BridgeElement)this.findUnique("from BridgeElement rec where rec.node.id = ? and rec.vlan is null", id);
        }
        return (BridgeElement)this.findUnique("from BridgeElement rec where rec.node.id = ? and rec.vlan = ?", id, vlanId);
    }

    public List<BridgeElement> findByBridgeId(String id) {
        return this.find("from BridgeElement rec where rec.baseBridgeAddress = ?", id);
    }

    public BridgeElement getByBridgeIdVlan(String id, Integer vlanId) {
        return (BridgeElement)this.findUnique("from BridgeElement rec where rec.baseBridgeAddress = ? and vlan = ?", id, vlanId);
    }

    public void deleteByNodeIdOlderThen(Integer nodeId, Date now) {
        for (BridgeElement elem : this.find("from BridgeElement rec where rec.node.id = ? and rec.bridgeNodeLastPollTime < ?", nodeId, now)) {
            this.delete(elem);
        }
    }

    public void deleteByNodeId(Integer nodeId) {
        for (BridgeElement rec : this.find("from BridgeElement rec where rec.node.id = ? ", nodeId)) {
            this.delete(rec);
        }
    }
}

