/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy;

public class FilesystemResourceStorageDaoTest {
    private FilesystemResourceStorageDao m_fsResourceStorageDao = new FilesystemResourceStorageDao();
    private String m_rrdFileExtension;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        JRobinRrdStrategy rrdStrategy = new JRobinRrdStrategy();
        this.m_rrdFileExtension = rrdStrategy.getDefaultFileExtension();
        this.m_fsResourceStorageDao.setRrdDirectory(this.tempFolder.getRoot());
        this.m_fsResourceStorageDao.setRrdStrategy((RrdStrategy)rrdStrategy);
    }

    @Test
    public void exists() throws IOException {
        Assert.assertFalse((boolean)this.m_fsResourceStorageDao.exists(ResourcePath.get((String[])new String[]{"should", "not", "exist"}), 0));
        File folder = this.tempFolder.newFolder("a");
        Assert.assertFalse((boolean)this.m_fsResourceStorageDao.exists(ResourcePath.get((String[])new String[]{"a"}), 0));
        File subFolder = this.tempFolder.newFolder(new String[]{"a", "b"});
        Assert.assertFalse((boolean)this.m_fsResourceStorageDao.exists(ResourcePath.get((String[])new String[]{"a"}), 1));
        File rrd = new File(subFolder, "ds" + this.m_rrdFileExtension);
        rrd.createNewFile();
        Assert.assertTrue((boolean)this.m_fsResourceStorageDao.exists(ResourcePath.get((String[])new String[]{"a"}), 1));
        Assert.assertTrue((boolean)rrd.delete());
        rrd = new File(folder, "ds" + this.m_rrdFileExtension);
        rrd.createNewFile();
        Assert.assertTrue((boolean)this.m_fsResourceStorageDao.exists(ResourcePath.get((String[])new String[]{"a"}), 0));
    }

    @Test
    public void existsWithin() throws IOException {
        File folder = this.tempFolder.newFolder(new String[]{"a", "b", "c"});
        File rrd = new File(folder, "ds" + this.m_rrdFileExtension);
        rrd.createNewFile();
        Assert.assertTrue((boolean)this.m_fsResourceStorageDao.exists(ResourcePath.get((String[])new String[]{"a", "b"}), 1));
        Assert.assertTrue((boolean)this.m_fsResourceStorageDao.existsWithin(ResourcePath.get((String[])new String[]{"a", "b"}), 1));
        Assert.assertTrue((boolean)this.m_fsResourceStorageDao.exists(ResourcePath.get((String[])new String[]{"a"}), 2));
        Assert.assertFalse((boolean)this.m_fsResourceStorageDao.existsWithin(ResourcePath.get((String[])new String[]{"a"}), 1));
        Assert.assertTrue((boolean)this.m_fsResourceStorageDao.existsWithin(ResourcePath.get((String[])new String[]{"a"}), 2));
        Assert.assertTrue((boolean)this.m_fsResourceStorageDao.existsWithin(ResourcePath.get((String[])new String[]{"a"}), 3));
    }

    @Test
    public void children() throws IOException {
        Assert.assertEquals((long)0L, (long)this.m_fsResourceStorageDao.children(ResourcePath.get((String[])new String[]{"should", "not", "exist"}), 1).size());
        File folder = this.tempFolder.newFolder("a");
        Assert.assertEquals((long)0L, (long)this.m_fsResourceStorageDao.children(ResourcePath.get((String[])new String[]{"a"}), 1).size());
        File rrd = new File(folder, "ds" + this.m_rrdFileExtension);
        rrd.createNewFile();
        Assert.assertEquals((long)0L, (long)this.m_fsResourceStorageDao.children(ResourcePath.get((String[])new String[]{"a"}), 1).size());
        Assert.assertTrue((boolean)rrd.delete());
        File subFolder = this.tempFolder.newFolder(new String[]{"a", "b"});
        Assert.assertEquals((long)0L, (long)this.m_fsResourceStorageDao.children(ResourcePath.get((String[])new String[]{"a"}), 1).size());
        rrd = new File(subFolder, "ds" + this.m_rrdFileExtension);
        rrd.createNewFile();
        Set children = this.m_fsResourceStorageDao.children(ResourcePath.get((String[])new String[]{"a"}), 1);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertEquals((Object)ResourcePath.get((String[])new String[]{"a", "b"}), children.iterator().next());
        children = this.m_fsResourceStorageDao.children(ResourcePath.get((String[])new String[]{"a"}), 1);
        Assert.assertEquals((long)1L, (long)children.size());
        Assert.assertEquals((Object)ResourcePath.get((String[])new String[]{"a", "b"}), children.iterator().next());
        Assert.assertTrue((boolean)rrd.delete());
    }

    @Test
    public void getAttributes() throws IOException {
        File subFolder = this.tempFolder.newFolder("a");
        Assert.assertFalse((boolean)this.m_fsResourceStorageDao.exists(ResourcePath.get((String[])new String[]{"a"}), 0));
        File rrd = new File(subFolder, "ds" + this.m_rrdFileExtension);
        rrd.createNewFile();
        Assert.assertTrue((boolean)this.m_fsResourceStorageDao.exists(ResourcePath.get((String[])new String[]{"a"}), 0));
        Set attributes = this.m_fsResourceStorageDao.getAttributes(ResourcePath.get((String[])new String[]{"a"}));
        Assert.assertEquals((long)1L, (long)attributes.size());
    }
}

