/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.Order;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.NotificationDao;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class NotificationDaoIT
implements InitializingBean {
    @Autowired
    private DatabasePopulator m_databasePopulator;
    @Autowired
    private DistPollerDao m_distPollerDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private NotificationDao m_notificationDao;
    @Autowired
    private EventDao m_eventDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_databasePopulator.populateDatabase();
    }

    @Test
    @Transactional
    public void testNotificationSave() {
        OnmsEvent event = new OnmsEvent();
        event.setDistPoller(this.m_distPollerDao.whoami());
        event.setEventCreateTime(new Date());
        event.setEventDescr("event dao test");
        event.setEventHost("localhost");
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        event.setEventLogGroup("event dao test log group");
        event.setEventLogMsg("event dao test log msg");
        event.setEventSeverity(Integer.valueOf(7));
        event.setEventSource("EventDaoTest");
        event.setEventTime(new Date());
        event.setEventUei("uei://org/opennms/test/NotificationDaoTest");
        OnmsNode node = (OnmsNode)this.m_nodeDao.findAll().iterator().next();
        OnmsIpInterface iface = (OnmsIpInterface)node.getIpInterfaces().iterator().next();
        OnmsMonitoredService service = (OnmsMonitoredService)iface.getMonitoredServices().iterator().next();
        event.setNode(node);
        event.setServiceType(service.getServiceType());
        event.setIpAddr(iface.getIpAddress());
        this.m_eventDao.save((Object)event);
        OnmsEvent newEvent = (OnmsEvent)this.m_eventDao.load((Serializable)event.getId());
        Assert.assertEquals((Object)"uei://org/opennms/test/NotificationDaoTest", (Object)newEvent.getEventUei());
        OnmsNotification notification = new OnmsNotification();
        notification.setEvent(newEvent);
        notification.setTextMsg("Tests are fun!");
        this.m_notificationDao.save((Object)notification);
        OnmsNotification newNotification = (OnmsNotification)this.m_notificationDao.load((Serializable)notification.getNotifyId());
        Assert.assertEquals((Object)"uei://org/opennms/test/NotificationDaoTest", (Object)newNotification.getEvent().getEventUei());
    }

    @Test
    @Transactional
    public void testCriteria() {
        Criteria criteria = new Criteria(OnmsNotification.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN), new Alias("node.snmpInterfaces", "snmpInterface", Alias.JoinType.LEFT_JOIN), new Alias("node.ipInterfaces", "ipInterface", Alias.JoinType.LEFT_JOIN), new Alias("event", "event", Alias.JoinType.LEFT_JOIN), new Alias("usersNotified", "usersNotified", Alias.JoinType.LEFT_JOIN), new Alias("serviceType", "serviceType", Alias.JoinType.LEFT_JOIN)));
        criteria.setOrders(Arrays.asList(new Order("event.id", false), new Order("event.eventSeverity", false), new Order("node.label", false), new Order("serviceType.name", false)));
        this.m_notificationDao.findMatching(criteria);
        CriteriaBuilder builder = new CriteriaBuilder(OnmsNotification.class);
        builder.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        builder.alias("node.snmpInterfaces", "snmpInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("node.ipInterfaces", "ipInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("event", "event", Alias.JoinType.LEFT_JOIN);
        builder.alias("usersNotified", "usersNotified", Alias.JoinType.LEFT_JOIN);
        builder.alias("serviceType", "serviceType", Alias.JoinType.LEFT_JOIN);
        builder.orderBy("event.id", false);
        builder.orderBy("event.eventSeverity", false);
        builder.orderBy("node.label", false);
        builder.orderBy("serviceType.name", false);
        this.m_notificationDao.findMatching(builder.toCriteria());
    }
}

