/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Collections;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.opennms.netmgt.dao.support.RrdStatisticAttributeVisitor;
import org.opennms.netmgt.measurements.api.FetchResults;
import org.opennms.netmgt.measurements.api.MeasurementFetchStrategy;
import org.opennms.netmgt.measurements.model.Source;
import org.opennms.netmgt.mock.MockResourceType;
import org.opennms.netmgt.model.AttributeStatisticVisitor;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.model.StringPropertyAttribute;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.EasyMockUtils;

public class RrdStatisticAttributeVisitorTest
extends TestCase {
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private MeasurementFetchStrategy m_fetchStrategy = (MeasurementFetchStrategy)this.m_mocks.createMock(MeasurementFetchStrategy.class);
    private Long m_startTime = System.currentTimeMillis();
    private Long m_endTime = this.m_startTime + 86400000L;
    private AttributeStatisticVisitor m_statisticVisitor = (AttributeStatisticVisitor)this.m_mocks.createMock(AttributeStatisticVisitor.class);

    public void testAfterPropertiesSet() throws Exception {
        RrdStatisticAttributeVisitor attributeVisitor = new RrdStatisticAttributeVisitor();
        attributeVisitor.setFetchStrategy(this.m_fetchStrategy);
        attributeVisitor.setConsolidationFunction("AVERAGE");
        attributeVisitor.setStartTime(this.m_startTime);
        attributeVisitor.setEndTime(this.m_endTime);
        attributeVisitor.setStatisticVisitor(this.m_statisticVisitor);
        attributeVisitor.afterPropertiesSet();
    }

    public void testAfterPropertiesSetNoStatisticVisitor() throws Exception {
        RrdStatisticAttributeVisitor attributeVisitor = new RrdStatisticAttributeVisitor();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("property statisticVisitor must be set to a non-null value"));
        attributeVisitor.setFetchStrategy(this.m_fetchStrategy);
        attributeVisitor.setConsolidationFunction("AVERAGE");
        attributeVisitor.setStartTime(this.m_startTime);
        attributeVisitor.setEndTime(this.m_endTime);
        attributeVisitor.setStatisticVisitor(null);
        try {
            attributeVisitor.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAfterPropertiesSetNoConsolidationFunction() throws Exception {
        RrdStatisticAttributeVisitor attributeVisitor = new RrdStatisticAttributeVisitor();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("property consolidationFunction must be set to a non-null value"));
        attributeVisitor.setFetchStrategy(this.m_fetchStrategy);
        attributeVisitor.setConsolidationFunction(null);
        attributeVisitor.setStartTime(this.m_startTime);
        attributeVisitor.setEndTime(this.m_endTime);
        attributeVisitor.setStatisticVisitor(this.m_statisticVisitor);
        try {
            attributeVisitor.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAfterPropertiesSetNoRrdDao() throws Exception {
        RrdStatisticAttributeVisitor attributeVisitor = new RrdStatisticAttributeVisitor();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("property fetchStrategy must be set to a non-null value"));
        attributeVisitor.setFetchStrategy(null);
        attributeVisitor.setConsolidationFunction("AVERAGE");
        attributeVisitor.setStartTime(this.m_startTime);
        attributeVisitor.setEndTime(this.m_endTime);
        attributeVisitor.setStatisticVisitor(this.m_statisticVisitor);
        try {
            attributeVisitor.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAfterPropertiesSetNoStartTime() throws Exception {
        RrdStatisticAttributeVisitor attributeVisitor = new RrdStatisticAttributeVisitor();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("property startTime must be set to a non-null value"));
        attributeVisitor.setFetchStrategy(this.m_fetchStrategy);
        attributeVisitor.setConsolidationFunction("AVERAGE");
        attributeVisitor.setStartTime(null);
        attributeVisitor.setEndTime(this.m_endTime);
        attributeVisitor.setStatisticVisitor(this.m_statisticVisitor);
        try {
            attributeVisitor.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAfterPropertiesSetNoEndTime() throws Exception {
        RrdStatisticAttributeVisitor attributeVisitor = new RrdStatisticAttributeVisitor();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("property endTime must be set to a non-null value"));
        attributeVisitor.setFetchStrategy(this.m_fetchStrategy);
        attributeVisitor.setConsolidationFunction("AVERAGE");
        attributeVisitor.setStartTime(this.m_startTime);
        attributeVisitor.setEndTime(null);
        attributeVisitor.setStatisticVisitor(this.m_statisticVisitor);
        try {
            attributeVisitor.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testVisitWithRrdAttribute() throws Exception {
        RrdStatisticAttributeVisitor attributeVisitor = new RrdStatisticAttributeVisitor();
        attributeVisitor.setFetchStrategy(this.m_fetchStrategy);
        attributeVisitor.setConsolidationFunction("AVERAGE");
        attributeVisitor.setStartTime(this.m_startTime);
        attributeVisitor.setEndTime(this.m_endTime);
        attributeVisitor.setStatisticVisitor(this.m_statisticVisitor);
        attributeVisitor.afterPropertiesSet();
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("interfaceSnmp");
        RrdGraphAttribute attribute = new RrdGraphAttribute("ifInOctets", "something", "something else");
        attribute.setResource(new OnmsResource("1", "Node One", (OnmsResourceType)resourceType, Collections.singleton(attribute), ResourcePath.get((String[])new String[]{"foo"})));
        Source source = new Source();
        source.setLabel("result");
        source.setResourceId(attribute.getResource().getId());
        source.setAttribute(attribute.getName());
        source.setAggregation(attributeVisitor.getConsolidationFunction().toUpperCase());
        FetchResults results = new FetchResults(new long[]{this.m_startTime}, Collections.singletonMap("result", new double[]{1.0}), this.m_endTime - this.m_startTime, Collections.emptyMap());
        EasyMock.expect((Object)this.m_fetchStrategy.fetch(this.m_startTime.longValue(), this.m_endTime.longValue(), 1L, 0, null, null, Collections.singletonList(source), false)).andReturn((Object)results);
        this.m_statisticVisitor.visit((OnmsAttribute)attribute, 1.0);
        this.m_mocks.replayAll();
        attributeVisitor.visit((OnmsAttribute)attribute);
        this.m_mocks.verifyAll();
    }

    public void testVisitWithNonRrdAttribute() throws Exception {
        RrdStatisticAttributeVisitor attributeVisitor = new RrdStatisticAttributeVisitor();
        attributeVisitor.setFetchStrategy(this.m_fetchStrategy);
        attributeVisitor.setConsolidationFunction("AVERAGE");
        attributeVisitor.setStartTime(this.m_startTime);
        attributeVisitor.setEndTime(this.m_endTime);
        attributeVisitor.setStatisticVisitor(this.m_statisticVisitor);
        attributeVisitor.afterPropertiesSet();
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("something other than interfaceSnmp");
        StringPropertyAttribute attribute = new StringPropertyAttribute("ifInOctets", "one billion octets!");
        attribute.setResource(new OnmsResource("1", "Node One", (OnmsResourceType)resourceType, Collections.singleton(attribute), ResourcePath.get((String[])new String[]{"foo"})));
        this.m_mocks.replayAll();
        attributeVisitor.visit((OnmsAttribute)attribute);
        this.m_mocks.verifyAll();
    }

    public void testVisitWithNotANumberRrdAttribute() throws Exception {
        RrdStatisticAttributeVisitor attributeVisitor = new RrdStatisticAttributeVisitor();
        attributeVisitor.setFetchStrategy(this.m_fetchStrategy);
        attributeVisitor.setConsolidationFunction("AVERAGE");
        attributeVisitor.setStartTime(this.m_startTime);
        attributeVisitor.setEndTime(this.m_endTime);
        attributeVisitor.setStatisticVisitor(this.m_statisticVisitor);
        attributeVisitor.afterPropertiesSet();
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("something other than interfaceSnmp");
        RrdGraphAttribute attribute = new RrdGraphAttribute("ifInOctets", "something", "something else");
        attribute.setResource(new OnmsResource("1", "Node One", (OnmsResourceType)resourceType, Collections.singleton(attribute), ResourcePath.get((String[])new String[]{"foo"})));
        Source source = new Source();
        source.setLabel("result");
        source.setResourceId(attribute.getResource().getId());
        source.setAttribute(attribute.getName());
        source.setAggregation(attributeVisitor.getConsolidationFunction().toUpperCase());
        FetchResults results = new FetchResults(new long[0], Collections.singletonMap("result", new double[0]), this.m_endTime - this.m_startTime, Collections.emptyMap());
        EasyMock.expect((Object)this.m_fetchStrategy.fetch(this.m_startTime.longValue(), this.m_endTime.longValue(), 1L, 0, null, null, Collections.singletonList(source), false)).andReturn((Object)results);
        this.m_mocks.replayAll();
        attributeVisitor.visit((OnmsAttribute)attribute);
        this.m_mocks.verifyAll();
    }
}

