/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.api.ResourceTypesDao;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.DefaultResourceDao;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy;
import org.opennms.test.FileAnticipator;
import org.opennms.test.mock.EasyMockUtils;

public class FindTopLevelResourcesTest {
    private EasyMockUtils m_easyMockUtils;
    private NodeDao m_nodeDao;
    private LocationMonitorDao m_locationMonitorDao;
    private CollectdConfigFactory m_collectdConfig;
    private ResourceTypesDao m_resourceTypesDao;
    private DefaultResourceDao m_resourceDao;
    private FilesystemResourceStorageDao m_resourceStorageDao = new FilesystemResourceStorageDao();
    private FileAnticipator m_fileAnticipator;
    private FilterDao m_filterDao;
    private String m_rrdFileExtension;

    @Before
    public void setUp() throws Exception {
        this.m_fileAnticipator = new FileAnticipator();
        this.m_easyMockUtils = new EasyMockUtils();
        this.m_nodeDao = (NodeDao)this.m_easyMockUtils.createMock(NodeDao.class);
        this.m_locationMonitorDao = (LocationMonitorDao)this.m_easyMockUtils.createMock(LocationMonitorDao.class);
        this.m_resourceTypesDao = (ResourceTypesDao)this.m_easyMockUtils.createMock(ResourceTypesDao.class);
        this.m_filterDao = (FilterDao)this.m_easyMockUtils.createMock(FilterDao.class);
        FilterDaoFactory.setInstance((FilterDao)this.m_filterDao);
        EasyMock.expect((Object)this.m_filterDao.getActiveIPAddressList("IPADDR IPLIKE *.*.*.*")).andReturn(new ArrayList(0)).anyTimes();
        JRobinRrdStrategy rrdStrategy = new JRobinRrdStrategy();
        this.m_rrdFileExtension = rrdStrategy.getDefaultFileExtension();
        this.m_resourceStorageDao.setRrdDirectory(this.m_fileAnticipator.getTempDir());
        this.m_resourceStorageDao.setRrdStrategy((RrdStrategy)rrdStrategy);
        this.m_easyMockUtils.replayAll();
        InputStream stream = ConfigurationTestUtils.getInputStreamForResource((Object)this, (String)"/collectdconfiguration-testdata.xml");
        this.m_collectdConfig = new CollectdConfigFactory(stream, "localhost", false);
        this.m_easyMockUtils.verifyAll();
        this.m_resourceDao = new DefaultResourceDao();
        this.m_resourceDao.setNodeDao(this.m_nodeDao);
        this.m_resourceDao.setLocationMonitorDao(this.m_locationMonitorDao);
        this.m_resourceDao.setCollectdConfig((org.opennms.netmgt.config.api.CollectdConfigFactory)this.m_collectdConfig);
        this.m_resourceDao.setResourceTypesDao(this.m_resourceTypesDao);
        this.m_resourceDao.setResourceStorageDao((ResourceStorageDao)this.m_resourceStorageDao);
    }

    @After
    public void tearDown() {
        this.m_fileAnticipator.tearDown();
        this.setStoreByForeignSource(false);
    }

    private void setStoreByForeignSource(boolean storeByForeignSource) {
        System.setProperty("org.opennms.rrd.storeByForeignSource", Boolean.toString(storeByForeignSource));
    }

    @Test
    public void testFindTopLevelResources_discoveredNodesWithoutStoreByForeignSource() throws Exception {
        this.setStoreByForeignSource(false);
        this.execute_testFindTopLevelResources_discoveredNodes();
    }

    @Test
    public void testFindTopLevelResources_discoveredNodesWithStoreByForeignSource() throws Exception {
        this.setStoreByForeignSource(true);
        this.execute_testFindTopLevelResources_discoveredNodes();
    }

    private void execute_testFindTopLevelResources_discoveredNodes() throws Exception {
        ArrayList<OnmsNode> nodes = new ArrayList<OnmsNode>();
        OnmsNode n1 = this.createNode(1, "node1", null, null, "10.0.0.1");
        nodes.add(n1);
        OnmsNode n2 = this.createNode(2, "node2", null, null, "10.0.0.2");
        nodes.add(n2);
        EasyMock.expect((Object)this.m_resourceTypesDao.getLastUpdate()).andReturn((Object)new Date(System.currentTimeMillis())).atLeastOnce();
        EasyMock.expect((Object)this.m_resourceTypesDao.getResourceTypes()).andReturn(new HashMap());
        EasyMock.expect((Object)this.m_nodeDao.findAll()).andReturn(nodes);
        EasyMock.expect((Object)this.m_locationMonitorDao.findStatusChangesForNodeForUniqueMonitorAndInterface(n1.getId().intValue())).andReturn(new ArrayList(0));
        EasyMock.expect((Object)this.m_locationMonitorDao.findStatusChangesForNodeForUniqueMonitorAndInterface(n2.getId().intValue())).andReturn(new ArrayList(0));
        File snmpDir = this.m_fileAnticipator.tempDir("snmp");
        File responseDir = this.m_fileAnticipator.tempDir("response");
        File nodeDir = this.m_fileAnticipator.tempDir(snmpDir, n1.getId().toString());
        this.m_fileAnticipator.tempFile(nodeDir, "data" + this.m_rrdFileExtension);
        File orphanDir = this.m_fileAnticipator.tempDir(snmpDir, "100");
        this.m_fileAnticipator.tempFile(orphanDir, "data" + this.m_rrdFileExtension);
        File ipDir = this.m_fileAnticipator.tempDir(responseDir, ((OnmsIpInterface)n1.getIpInterfaces().iterator().next()).getIpAddress().getHostAddress());
        this.m_fileAnticipator.tempFile(ipDir, "icmp" + this.m_rrdFileExtension);
        this.m_easyMockUtils.replayAll();
        this.m_resourceDao.afterPropertiesSet();
        List resources = this.m_resourceDao.findTopLevelResources();
        Assert.assertNotNull((Object)resources);
        Collections.sort(resources);
        Assert.assertEquals((long)1L, (long)resources.size());
        List children = ((OnmsResource)resources.get(0)).getChildResources();
        Collections.sort(children);
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertEquals((Object)"node[1].responseTime[10.0.0.1]", (Object)((OnmsResource)children.get(0)).getId());
        Assert.assertEquals((Object)"node[1].nodeSnmp[]", (Object)((OnmsResource)children.get(1)).getId());
        this.m_easyMockUtils.verifyAll();
    }

    @Test
    public void testFindTopLevelResources_provisionedNodesWithoutStoreByForeignSource() throws Exception {
        this.execute_testFindTopLevelResources_provisionedNodes(false);
    }

    @Test
    public void testFindTopLevelResources_provisionedNodesWithStoreByForeignSource() throws Exception {
        this.execute_testFindTopLevelResources_provisionedNodes(true);
    }

    private void execute_testFindTopLevelResources_provisionedNodes(boolean storeByForeignSource) throws Exception {
        this.setStoreByForeignSource(storeByForeignSource);
        ArrayList<OnmsNode> nodes = new ArrayList<OnmsNode>();
        String foreignSource = "Junit";
        OnmsNode n1 = this.createNode(1, "node1", "Junit", "node1", "10.0.0.1");
        nodes.add(n1);
        OnmsNode n2 = this.createNode(2, "node2", "Junit", "node2", "10.0.0.2");
        nodes.add(n2);
        OnmsNode n3 = this.createNode(3, "node3", "Junit", "node3", "10.0.0.3");
        nodes.add(n3);
        EasyMock.expect((Object)this.m_resourceTypesDao.getLastUpdate()).andReturn((Object)new Date(System.currentTimeMillis())).atLeastOnce();
        EasyMock.expect((Object)this.m_resourceTypesDao.getResourceTypes()).andReturn(new HashMap());
        EasyMock.expect((Object)this.m_nodeDao.findAll()).andReturn(nodes);
        EasyMock.expect((Object)this.m_locationMonitorDao.findStatusChangesForNodeForUniqueMonitorAndInterface(n1.getId().intValue())).andReturn(new ArrayList(0));
        EasyMock.expect((Object)this.m_locationMonitorDao.findStatusChangesForNodeForUniqueMonitorAndInterface(n2.getId().intValue())).andReturn(new ArrayList(0));
        EasyMock.expect((Object)this.m_locationMonitorDao.findStatusChangesForNodeForUniqueMonitorAndInterface(n3.getId().intValue())).andReturn(new ArrayList(0));
        File snmpDir = this.m_fileAnticipator.tempDir("snmp");
        File responseDir = this.m_fileAnticipator.tempDir("response");
        File fsDir = this.m_fileAnticipator.tempDir(snmpDir, "fs");
        File foreignSourceDir = this.m_fileAnticipator.tempDir(fsDir, "Junit");
        File nodeDir = null;
        nodeDir = storeByForeignSource ? this.m_fileAnticipator.tempDir(foreignSourceDir, n1.getForeignId()) : this.m_fileAnticipator.tempDir(snmpDir, n1.getId().toString());
        this.m_fileAnticipator.tempFile(nodeDir, "data" + this.m_rrdFileExtension);
        nodeDir = storeByForeignSource ? this.m_fileAnticipator.tempDir(foreignSourceDir, n2.getForeignId()) : this.m_fileAnticipator.tempDir(snmpDir, n2.getId().toString());
        this.m_fileAnticipator.tempFile(nodeDir, "data" + this.m_rrdFileExtension);
        nodeDir = storeByForeignSource ? this.m_fileAnticipator.tempDir(foreignSourceDir, "orphan_node") : this.m_fileAnticipator.tempDir(snmpDir, "100");
        this.m_fileAnticipator.tempFile(nodeDir, "data" + this.m_rrdFileExtension);
        File ipDir = this.m_fileAnticipator.tempDir(responseDir, ((OnmsIpInterface)n1.getIpInterfaces().iterator().next()).getIpAddress().getHostAddress());
        this.m_fileAnticipator.tempFile(ipDir, "icmp" + this.m_rrdFileExtension);
        this.walkin(this.m_fileAnticipator.getTempDir());
        this.m_easyMockUtils.replayAll();
        this.m_resourceDao.afterPropertiesSet();
        List resources = this.m_resourceDao.findTopLevelResources();
        Assert.assertNotNull((Object)resources);
        Collections.sort(resources);
        Assert.assertEquals((long)2L, (long)resources.size());
        List children = ((OnmsResource)resources.get(0)).getChildResources();
        Collections.sort(children);
        Assert.assertEquals((long)2L, (long)children.size());
        if (storeByForeignSource) {
            Assert.assertEquals((Object)"nodeSource[Junit%3Anode1].responseTime[10.0.0.1]", (Object)((OnmsResource)children.get(0)).getId());
            Assert.assertEquals((Object)"nodeSource[Junit%3Anode1].nodeSnmp[]", (Object)((OnmsResource)children.get(1)).getId());
        } else {
            Assert.assertEquals((Object)"node[1].responseTime[10.0.0.1]", (Object)((OnmsResource)children.get(0)).getId());
            Assert.assertEquals((Object)"node[1].nodeSnmp[]", (Object)((OnmsResource)children.get(1)).getId());
        }
        children = ((OnmsResource)resources.get(1)).getChildResources();
        Collections.sort(children);
        Assert.assertEquals((long)1L, (long)children.size());
        if (storeByForeignSource) {
            Assert.assertEquals((Object)"nodeSource[Junit%3Anode2].nodeSnmp[]", (Object)((OnmsResource)children.get(0)).getId());
        } else {
            Assert.assertEquals((Object)"node[2].nodeSnmp[]", (Object)((OnmsResource)children.get(0)).getId());
        }
        this.m_easyMockUtils.verifyAll();
    }

    @Test
    public void testFindTopLevelResources_hybridNodesWithoutStoreByForeignSource() throws Exception {
        this.execute_testFindTopLevelResources_hybridNodes(false);
    }

    @Test
    public void testGetTopLevelResources_hybridNodesWithStoreByForeignSource() throws Exception {
        this.execute_testFindTopLevelResources_hybridNodes(true);
    }

    private void execute_testFindTopLevelResources_hybridNodes(boolean storeByForeignSource) throws Exception {
        this.setStoreByForeignSource(storeByForeignSource);
        String foreignSource = "Junit";
        ArrayList<OnmsNode> nodes = new ArrayList<OnmsNode>();
        OnmsNode n1 = this.createNode(1, "node1", null, null, "10.0.0.1");
        nodes.add(n1);
        OnmsNode n2 = this.createNode(2, "node2", "Junit", "node2", "10.0.0.2");
        nodes.add(n2);
        OnmsNode n3 = this.createNode(3, "node3", null, null, "10.0.0.3");
        nodes.add(n3);
        OnmsNode n4 = this.createNode(4, "node4", "Junit", "node4", "10.0.0.4");
        nodes.add(n4);
        EasyMock.expect((Object)this.m_resourceTypesDao.getLastUpdate()).andReturn((Object)new Date(System.currentTimeMillis())).atLeastOnce();
        EasyMock.expect((Object)this.m_resourceTypesDao.getResourceTypes()).andReturn(new HashMap());
        EasyMock.expect((Object)this.m_nodeDao.findAll()).andReturn(nodes);
        EasyMock.expect((Object)this.m_locationMonitorDao.findStatusChangesForNodeForUniqueMonitorAndInterface(n1.getId().intValue())).andReturn(new ArrayList(0));
        EasyMock.expect((Object)this.m_locationMonitorDao.findStatusChangesForNodeForUniqueMonitorAndInterface(n2.getId().intValue())).andReturn(new ArrayList(0));
        EasyMock.expect((Object)this.m_locationMonitorDao.findStatusChangesForNodeForUniqueMonitorAndInterface(n3.getId().intValue())).andReturn(new ArrayList(0));
        EasyMock.expect((Object)this.m_locationMonitorDao.findStatusChangesForNodeForUniqueMonitorAndInterface(n4.getId().intValue())).andReturn(new ArrayList(0));
        File snmpDir = this.m_fileAnticipator.tempDir("snmp");
        File responseDir = this.m_fileAnticipator.tempDir("response");
        File featureDir = this.m_fileAnticipator.tempDir(snmpDir, "fs");
        File fsDir = this.m_fileAnticipator.tempDir(featureDir, "Junit");
        File node1Dir = this.m_fileAnticipator.tempDir(snmpDir, n1.getId().toString());
        this.m_fileAnticipator.tempFile(node1Dir, "data" + this.m_rrdFileExtension);
        File node2Dir = null;
        node2Dir = storeByForeignSource ? this.m_fileAnticipator.tempDir(fsDir, n2.getForeignId()) : this.m_fileAnticipator.tempDir(snmpDir, n2.getId().toString());
        this.m_fileAnticipator.tempFile(node2Dir, "data" + this.m_rrdFileExtension);
        this.m_fileAnticipator.tempFile(this.m_fileAnticipator.tempDir(snmpDir, "100"), "data" + this.m_rrdFileExtension);
        File orphanDir = null;
        orphanDir = storeByForeignSource ? this.m_fileAnticipator.tempDir(fsDir, "orphan_node") : this.m_fileAnticipator.tempDir(snmpDir, "101");
        this.m_fileAnticipator.tempFile(orphanDir, "data" + this.m_rrdFileExtension);
        File ip1Dir = this.m_fileAnticipator.tempDir(responseDir, ((OnmsIpInterface)n1.getIpInterfaces().iterator().next()).getIpAddress().getHostAddress());
        this.m_fileAnticipator.tempFile(ip1Dir, "icmp" + this.m_rrdFileExtension);
        File ip2Dir = this.m_fileAnticipator.tempDir(responseDir, ((OnmsIpInterface)n2.getIpInterfaces().iterator().next()).getIpAddress().getHostAddress());
        this.m_fileAnticipator.tempFile(ip2Dir, "icmp" + this.m_rrdFileExtension);
        this.m_easyMockUtils.replayAll();
        this.m_resourceDao.afterPropertiesSet();
        List resources = this.m_resourceDao.findTopLevelResources();
        Assert.assertNotNull((Object)resources);
        Collections.sort(resources);
        Assert.assertEquals((long)2L, (long)resources.size());
        if (storeByForeignSource) {
            OnmsResource r1 = (OnmsResource)resources.get(0);
            List children1 = r1.getChildResources();
            Collections.sort(children1);
            Assert.assertEquals((Object)"nodeSource[Junit%3Anode2]", (Object)r1.getId());
            Assert.assertEquals((Object)"nodeSource[Junit%3Anode2].responseTime[10.0.0.2]", (Object)((OnmsResource)children1.get(0)).getId());
            Assert.assertEquals((Object)"nodeSource[Junit%3Anode2].nodeSnmp[]", (Object)((OnmsResource)children1.get(1)).getId());
            OnmsResource r2 = (OnmsResource)resources.get(1);
            Assert.assertEquals((Object)"node[1]", (Object)r2.getId());
            List children2 = r2.getChildResources();
            Collections.sort(children2);
            Assert.assertEquals((long)2L, (long)children2.size());
            Assert.assertEquals((Object)"node[1].responseTime[10.0.0.1]", (Object)((OnmsResource)children2.get(0)).getId());
            Assert.assertEquals((Object)"node[1].nodeSnmp[]", (Object)((OnmsResource)children2.get(1)).getId());
        } else {
            OnmsResource r1 = (OnmsResource)resources.get(1);
            List children1 = r1.getChildResources();
            Collections.sort(children1);
            Assert.assertEquals((Object)"node[2]", (Object)r1.getId());
            Assert.assertEquals((Object)"node[2].responseTime[10.0.0.2]", (Object)((OnmsResource)children1.get(0)).getId());
            Assert.assertEquals((Object)"node[2].nodeSnmp[]", (Object)((OnmsResource)children1.get(1)).getId());
            OnmsResource r2 = (OnmsResource)resources.get(0);
            Assert.assertEquals((Object)"node[1]", (Object)r2.getId());
            List children2 = r2.getChildResources();
            Collections.sort(children2);
            Assert.assertEquals((long)2L, (long)children2.size());
            Assert.assertEquals((Object)"node[1].responseTime[10.0.0.1]", (Object)((OnmsResource)children2.get(0)).getId());
            Assert.assertEquals((Object)"node[1].nodeSnmp[]", (Object)((OnmsResource)children2.get(1)).getId());
        }
        this.m_easyMockUtils.verifyAll();
    }

    private OnmsNode createNode(int nodeId, String nodelabel, String foreignSource, String foreignId, String ipAddress) {
        OnmsNode n = new OnmsNode();
        n.setId(Integer.valueOf(nodeId));
        n.setLabel(nodelabel);
        if (foreignSource != null) {
            n.setForeignSource(foreignSource);
        }
        if (foreignId != null) {
            n.setForeignId(foreignId);
        }
        OnmsIpInterface ip = new OnmsIpInterface();
        ip.setId(Integer.valueOf(10 + nodeId));
        ip.setIpAddress(InetAddressUtils.addr((String)ipAddress));
        ip.setNode(n);
        n.addIpInterface(ip);
        return n;
    }

    public void walkin(File dir) {
        File[] listFile = dir.listFiles();
        if (listFile != null) {
            for (int i = 0; i < listFile.length; ++i) {
                if (listFile[i].isDirectory()) {
                    this.walkin(listFile[i]);
                    continue;
                }
                System.out.println(listFile[i]);
            }
        }
    }
}

