/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.easymock.EasyMock;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.api.ResourceTypesDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.DefaultResourceDao;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.model.LocationMonitorIpInterface;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy;
import org.opennms.test.FileAnticipator;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.EasyMockUtils;

public class DefaultResourceDaoTest {
    private static final String LOCATION_MONITOR_ID = UUID.randomUUID().toString();
    private EasyMockUtils m_easyMockUtils;
    private NodeDao m_nodeDao;
    private LocationMonitorDao m_locationMonitorDao;
    private CollectdConfigFactory m_collectdConfig;
    private ResourceTypesDao m_resourceTypesDao;
    private DefaultResourceDao m_resourceDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private FilesystemResourceStorageDao m_resourceStorageDao = new FilesystemResourceStorageDao();
    private FileAnticipator m_fileAnticipator;
    private FilterDao m_filterDao;
    private Date m_lastUpdateTime = new Date();
    private String m_rrdFileExtension;

    @Before
    public void setUp() throws Exception {
        this.m_fileAnticipator = new FileAnticipator();
        this.m_easyMockUtils = new EasyMockUtils();
        this.m_nodeDao = (NodeDao)this.m_easyMockUtils.createMock(NodeDao.class);
        this.m_locationMonitorDao = (LocationMonitorDao)this.m_easyMockUtils.createMock(LocationMonitorDao.class);
        this.m_resourceTypesDao = (ResourceTypesDao)this.m_easyMockUtils.createMock(ResourceTypesDao.class);
        this.m_filterDao = (FilterDao)this.m_easyMockUtils.createMock(FilterDao.class);
        this.m_ipInterfaceDao = (IpInterfaceDao)this.m_easyMockUtils.createMock(IpInterfaceDao.class);
        FilterDaoFactory.setInstance((FilterDao)this.m_filterDao);
        EasyMock.expect((Object)this.m_filterDao.getActiveIPAddressList("IPADDR IPLIKE *.*.*.*")).andReturn(new ArrayList(0)).anyTimes();
        this.m_easyMockUtils.replayAll();
        this.setUpCollectdConfigFactory();
        this.m_easyMockUtils.verifyAll();
        JRobinRrdStrategy rrdStrategy = new JRobinRrdStrategy();
        this.m_rrdFileExtension = rrdStrategy.getDefaultFileExtension();
        this.m_resourceStorageDao.setRrdDirectory(this.m_fileAnticipator.getTempDir());
        this.m_resourceStorageDao.setRrdStrategy((RrdStrategy)rrdStrategy);
        this.m_resourceDao = new DefaultResourceDao();
        this.m_resourceDao.setNodeDao(this.m_nodeDao);
        this.m_resourceDao.setLocationMonitorDao(this.m_locationMonitorDao);
        this.m_resourceDao.setIpInterfaceDao(this.m_ipInterfaceDao);
        this.m_resourceDao.setCollectdConfig((org.opennms.netmgt.config.api.CollectdConfigFactory)this.m_collectdConfig);
        this.m_resourceDao.setResourceTypesDao(this.m_resourceTypesDao);
        this.m_resourceDao.setResourceStorageDao((ResourceStorageDao)this.m_resourceStorageDao);
        EasyMock.expect((Object)this.m_resourceTypesDao.getResourceTypes()).andReturn(new HashMap());
        EasyMock.expect((Object)this.m_resourceTypesDao.getLastUpdate()).andReturn((Object)this.m_lastUpdateTime);
        this.m_easyMockUtils.replayAll();
        this.m_resourceDao.afterPropertiesSet();
        this.m_easyMockUtils.verifyAll();
    }

    @After
    public void tearDown() {
        this.m_fileAnticipator.tearDown();
    }

    private void setUpCollectdConfigFactory() throws MarshalException, ValidationException, IOException {
        InputStream stream = ConfigurationTestUtils.getInputStreamForResource((Object)this, (String)"/collectdconfiguration-testdata.xml");
        this.m_collectdConfig = new CollectdConfigFactory(stream, "localhost", false);
        stream.close();
    }

    @Test
    public void testGetResourceByIdNewEmpty() {
        this.m_easyMockUtils.replayAll();
        this.m_resourceDao.getResourceById("");
        this.m_easyMockUtils.verifyAll();
    }

    @Test
    public void testGetResourceByIdNewTopLevelOnly() throws Exception {
        OnmsNode node = this.createNode();
        EasyMock.expect((Object)this.m_nodeDao.get((Serializable)node.getId())).andReturn((Object)node).times(1);
        File responseDir = this.m_fileAnticipator.tempDir("snmp");
        File nodeDir = this.m_fileAnticipator.tempDir(responseDir, node.getId().toString());
        this.m_fileAnticipator.tempFile(nodeDir, "foo" + this.m_rrdFileExtension);
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceById("node[1]");
        this.m_easyMockUtils.verifyAll();
        Assert.assertNotNull((String)"resource should not be null", (Object)resource);
    }

    @Test
    public void testGetResourceByIdNewTwoLevel() throws Exception {
        OnmsIpInterface ip = this.createIpInterfaceOnNode();
        EasyMock.expect((Object)this.m_nodeDao.get((Serializable)ip.getNode().getId())).andReturn((Object)ip.getNode()).times(1);
        EasyMock.expect((Object)this.m_ipInterfaceDao.get(ip.getNode(), "192.168.1.1")).andReturn((Object)ip).times(1);
        EasyMock.expect((Object)this.m_resourceTypesDao.getLastUpdate()).andReturn((Object)new Date(System.currentTimeMillis() - 86400000L)).anyTimes();
        File response = this.m_fileAnticipator.tempDir("response");
        File ipDir = this.m_fileAnticipator.tempDir(response, "192.168.1.1");
        this.m_fileAnticipator.tempFile(ipDir, "icmp" + this.m_rrdFileExtension);
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceById("node[1].responseTime[192.168.1.1]");
        this.m_easyMockUtils.verifyAll();
        Assert.assertNotNull((String)"resource should not be null", (Object)resource);
    }

    @Test
    public void testGetTopLevelResourceNodeExists() throws Exception {
        OnmsNode node = this.createNode();
        EasyMock.expect((Object)this.m_nodeDao.get((Serializable)node.getId())).andReturn((Object)node).times(1);
        File responseDir = this.m_fileAnticipator.tempDir("snmp");
        File nodeDir = this.m_fileAnticipator.tempDir(responseDir, node.getId().toString());
        this.m_fileAnticipator.tempFile(nodeDir, "foo" + this.m_rrdFileExtension);
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceById(String.format("node[%d]", node.getId()));
        this.m_easyMockUtils.verifyAll();
        Assert.assertNotNull((String)"Resource should not be null", (Object)resource);
    }

    @Test
    public void testGetTopLevelResourceNodeSourceExists() throws Exception {
        OnmsNode node = this.createNode();
        EasyMock.expect((Object)this.m_nodeDao.findByForeignId("source1", "123")).andReturn((Object)node).times(1);
        File responseDir = this.m_fileAnticipator.tempDir("snmp");
        File forSrcDir = this.m_fileAnticipator.tempDir(responseDir, "fs");
        File sourceDir = this.m_fileAnticipator.tempDir(forSrcDir, "source1");
        File idDir = this.m_fileAnticipator.tempDir(sourceDir, "123");
        this.m_fileAnticipator.tempFile(idDir, "foo" + this.m_rrdFileExtension);
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceById(String.format("nodeSource[source1:123]", node.getId()));
        this.m_easyMockUtils.verifyAll();
        Assert.assertNotNull((String)"Resource should not be null", (Object)resource);
    }

    @Test
    public void testGetTopLevelResourceNodeDoesNotExist() {
        EasyMock.expect((Object)this.m_nodeDao.get((Serializable)Integer.valueOf(2))).andReturn(null);
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceById(String.format("node[%d]", 2));
        this.m_easyMockUtils.verifyAll();
        Assert.assertNull((String)"Resource should be null", (Object)resource);
    }

    @Test
    public void testGetTopLevelResourceNodeExistsNoChildResources() throws Exception {
        OnmsNode node = this.createNode(2, "Node Two");
        EasyMock.expect((Object)this.m_nodeDao.get((Serializable)node.getId())).andReturn((Object)node).times(1);
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceById(String.format("node[%d]", 2));
        this.m_easyMockUtils.verifyAll();
        Assert.assertNotNull((String)"Resource should not be null", (Object)resource);
    }

    @Test
    public void testGetTopLevelResourceDomainExists() throws IOException {
        File snmp = this.m_fileAnticipator.tempDir("snmp");
        File domain = this.m_fileAnticipator.tempDir(snmp, "example1");
        File intf = this.m_fileAnticipator.tempDir(domain, "server1");
        this.m_fileAnticipator.tempFile(intf, "ifInOctects" + this.m_rrdFileExtension);
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceById(String.format("domain[%s]", "example1"));
        this.m_easyMockUtils.verifyAll();
        Assert.assertNotNull((String)"Resource should not be null", (Object)resource);
    }

    @Test
    public void testGetTopLevelResourceDomainDoesNotExistInCollectdConfig() {
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceById(String.format("domain[%s]", "bogus"));
        this.m_easyMockUtils.verifyAll();
        Assert.assertNull((String)"Resource should be null", (Object)resource);
    }

    @Test
    public void testGetTopLevelResourceDomainDoesNotExistNoInterfaceDirectories() throws IOException {
        File snmp = this.m_fileAnticipator.tempDir("snmp");
        this.m_fileAnticipator.tempDir(snmp, "example1");
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceById(String.format("domain[%s]", "example1"));
        this.m_easyMockUtils.verifyAll();
        Assert.assertNull((String)"Resource should be null", (Object)resource);
    }

    @Test
    public void testGetTopLevelResourceWithInvalidResourceType() {
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceById("bogus");
        this.m_easyMockUtils.verifyAll();
        Assert.assertNull((String)"Resource should be null", (Object)resource);
    }

    @Test
    public void testGetResourceDomainInterfaceExists() throws IOException {
        File snmp = this.m_fileAnticipator.tempDir("snmp");
        File domain = this.m_fileAnticipator.tempDir(snmp, "example1");
        File intf = this.m_fileAnticipator.tempDir(domain, "server1");
        this.m_fileAnticipator.tempFile(intf, "ifInOctects" + this.m_rrdFileExtension);
        EasyMock.expect((Object)this.m_resourceTypesDao.getLastUpdate()).andReturn((Object)new Date(System.currentTimeMillis() - 86400000L)).anyTimes();
        String resourceId = OnmsResource.createResourceId((String[])new String[]{"domain", "example1", "interfaceSnmp", "server1"});
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceById(resourceId);
        this.m_easyMockUtils.verifyAll();
        Assert.assertNotNull((String)"Resource should not be null", (Object)resource);
    }

    @Test
    public void testGetResourceNoNode() throws Exception {
        String resourceId = OnmsResource.createResourceId((String[])new String[]{"node", "1", "nodeSnmp", ""});
        EasyMock.expect((Object)this.m_nodeDao.get((Serializable)Integer.valueOf(1))).andReturn(null);
        this.m_easyMockUtils.replayAll();
        this.m_resourceDao.getResourceById(resourceId);
        this.m_easyMockUtils.verifyAll();
    }

    @Test
    public void testFindNodeResourcesWithResponseTime() throws Exception {
        LinkedList<OnmsNode> nodes = new LinkedList<OnmsNode>();
        OnmsNode node = this.createNode();
        OnmsIpInterface ip = this.createIpInterface();
        node.addIpInterface(ip);
        nodes.add(node);
        EasyMock.expect((Object)this.m_nodeDao.findAll()).andReturn(nodes);
        File response = this.m_fileAnticipator.tempDir("response");
        File ipDir = this.m_fileAnticipator.tempDir(response, "192.168.1.1");
        this.m_fileAnticipator.tempFile(ipDir, "icmp" + this.m_rrdFileExtension);
        EasyMock.expect((Object)this.m_resourceTypesDao.getLastUpdate()).andReturn((Object)this.m_lastUpdateTime);
        this.m_easyMockUtils.replayAll();
        List resources = this.m_resourceDao.findNodeResources();
        this.m_easyMockUtils.verifyAll();
        Assert.assertNotNull((String)"resource list should not be null", (Object)resources);
        Assert.assertEquals((String)"resource list size", (long)1L, (long)resources.size());
    }

    @Test
    public void testFindNodeResourcesWithDistributedResponseTime() throws Exception {
        LinkedList<OnmsNode> nodes = new LinkedList<OnmsNode>();
        OnmsNode node = this.createNode();
        OnmsIpInterface ip = this.createIpInterface();
        node.addIpInterface(ip);
        nodes.add(node);
        EasyMock.expect((Object)this.m_nodeDao.findAll()).andReturn(nodes);
        File response = this.m_fileAnticipator.tempDir("response");
        File distributed = this.m_fileAnticipator.tempDir(response, "distributed");
        File monitor = this.m_fileAnticipator.tempDir(distributed, LOCATION_MONITOR_ID);
        File ipDir = this.m_fileAnticipator.tempDir(monitor, "192.168.1.1");
        this.m_fileAnticipator.tempFile(ipDir, "icmp" + this.m_rrdFileExtension);
        EasyMock.expect((Object)this.m_resourceTypesDao.getLastUpdate()).andReturn((Object)this.m_lastUpdateTime);
        OnmsLocationMonitor locMon = new OnmsLocationMonitor();
        locMon.setId(LOCATION_MONITOR_ID);
        OnmsIpInterface ipIntf = new OnmsIpInterface();
        ipIntf.setIpAddress(InetAddress.getByName("192.168.1.1"));
        LocationMonitorIpInterface locMonIpIntf = new LocationMonitorIpInterface(locMon, ipIntf);
        EasyMock.expect((Object)this.m_locationMonitorDao.findStatusChangesForNodeForUniqueMonitorAndInterface(node.getId().intValue())).andReturn(Collections.singleton(locMonIpIntf)).anyTimes();
        this.m_easyMockUtils.replayAll();
        List resources = this.m_resourceDao.findNodeResources();
        this.m_easyMockUtils.verifyAll();
        Assert.assertNotNull((String)"Resource list should not be null", (Object)resources);
        Assert.assertEquals((String)"Resource list size", (long)1L, (long)resources.size());
    }

    @Test
    public void testFindNodeResourcesWithNodeSnmp() throws Exception {
        LinkedList<OnmsNode> nodes = new LinkedList<OnmsNode>();
        OnmsNode node = this.createNode();
        OnmsIpInterface ip = this.createIpInterface();
        node.addIpInterface(ip);
        nodes.add(node);
        EasyMock.expect((Object)this.m_nodeDao.findAll()).andReturn(nodes);
        File snmp = this.m_fileAnticipator.tempDir("snmp");
        File nodeDir = this.m_fileAnticipator.tempDir(snmp, "1");
        this.m_fileAnticipator.tempFile(nodeDir, "foo" + this.m_rrdFileExtension);
        EasyMock.expect((Object)this.m_resourceTypesDao.getLastUpdate()).andReturn((Object)this.m_lastUpdateTime);
        this.m_easyMockUtils.replayAll();
        List resources = this.m_resourceDao.findNodeResources();
        this.m_easyMockUtils.verifyAll();
        Assert.assertNotNull((String)"resource list should not be null", (Object)resources);
        Assert.assertEquals((String)"resource list size", (long)1L, (long)resources.size());
    }

    @Test
    public void testFindNodeResourcesWithNodeInterface() throws Exception {
        LinkedList<OnmsNode> nodes = new LinkedList<OnmsNode>();
        OnmsNode node = this.createNode();
        OnmsIpInterface ip = this.createIpInterface();
        node.addIpInterface(ip);
        nodes.add(node);
        EasyMock.expect((Object)this.m_nodeDao.findAll()).andReturn(nodes);
        File snmp = this.m_fileAnticipator.tempDir("snmp");
        File nodeDir = this.m_fileAnticipator.tempDir(snmp, "1");
        File intfDir = this.m_fileAnticipator.tempDir(nodeDir, "eth0");
        this.m_fileAnticipator.tempFile(intfDir, "foo" + this.m_rrdFileExtension);
        EasyMock.expect((Object)this.m_resourceTypesDao.getLastUpdate()).andReturn((Object)this.m_lastUpdateTime);
        this.m_easyMockUtils.replayAll();
        List resources = this.m_resourceDao.findNodeResources();
        this.m_easyMockUtils.verifyAll();
        Assert.assertNotNull((String)"resource list should not be null", (Object)resources);
        Assert.assertEquals((String)"resource list size", (long)1L, (long)resources.size());
    }

    @Test
    public void testGetResourceForNode() throws Exception {
        OnmsNode node = this.createNode();
        File responseDir = this.m_fileAnticipator.tempDir("snmp");
        File nodeDir = this.m_fileAnticipator.tempDir(responseDir, node.getId().toString());
        this.m_fileAnticipator.tempFile(nodeDir, "foo" + this.m_rrdFileExtension);
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceForNode(node);
        this.m_easyMockUtils.verifyAll();
        Assert.assertNotNull((String)"Resource should not be null", (Object)resource);
    }

    @Test
    public void testGetResourceForNodeWithNullOnmsNode() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("node argument must not be null"));
        this.m_easyMockUtils.replayAll();
        try {
            this.m_resourceDao.getResourceForNode(null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        this.m_easyMockUtils.verifyAll();
        ta.verifyAnticipated();
    }

    @Test
    public void testGetResourceForIpInterfaceWithLocationMonitor() throws Exception {
        OnmsIpInterface ip = this.createIpInterfaceOnNode();
        OnmsLocationMonitor locMon = new OnmsLocationMonitor();
        locMon.setId(LOCATION_MONITOR_ID);
        File response = this.m_fileAnticipator.tempDir("response");
        File distributed = this.m_fileAnticipator.tempDir(response, "distributed");
        File locMonDir = this.m_fileAnticipator.tempDir(distributed, locMon.getId().toString());
        File ipDir = this.m_fileAnticipator.tempDir(locMonDir, InetAddressUtils.str((InetAddress)ip.getIpAddress()));
        this.m_fileAnticipator.tempFile(ipDir, "http" + this.m_rrdFileExtension);
        ArrayList<LocationMonitorIpInterface> locationMonitorInterfaces = new ArrayList<LocationMonitorIpInterface>();
        locationMonitorInterfaces.add(new LocationMonitorIpInterface(locMon, ip));
        EasyMock.expect((Object)this.m_locationMonitorDao.findStatusChangesForNodeForUniqueMonitorAndInterface(ip.getNode().getId().intValue())).andReturn(locationMonitorInterfaces);
        EasyMock.expect((Object)this.m_resourceTypesDao.getLastUpdate()).andReturn((Object)new Date(System.currentTimeMillis() - 86400000L)).anyTimes();
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceForIpInterface(ip, locMon);
        this.m_easyMockUtils.verifyAll();
        Assert.assertNotNull((String)"Resource should not be null", (Object)resource);
    }

    @Test
    public void testGetResourceForNodeWithData() throws Exception {
        OnmsNode node = this.createNode();
        File responseDir = this.m_fileAnticipator.tempDir("snmp");
        File nodeDir = this.m_fileAnticipator.tempDir(responseDir, node.getId().toString());
        this.m_fileAnticipator.tempFile(nodeDir, "foo" + this.m_rrdFileExtension);
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceForNode(node);
        this.m_easyMockUtils.verifyAll();
        Assert.assertNotNull((String)"Resource should exist", (Object)resource);
    }

    @Test
    public void testGetResourceForNodeNoData() {
        OnmsNode node = this.createNode();
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceForNode(node);
        this.m_easyMockUtils.verifyAll();
        Assert.assertNotNull((String)"Resource should exist", (Object)resource);
    }

    private OnmsNode createNode() {
        return this.createNode(1, "Node One");
    }

    private OnmsNode createNode(int id, String label) {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(id));
        node.setLabel(label);
        return node;
    }

    private OnmsIpInterface createIpInterface() throws UnknownHostException {
        OnmsIpInterface ip = new OnmsIpInterface();
        ip.setIpAddress(InetAddressUtils.addr((String)"192.168.1.1"));
        return ip;
    }

    private OnmsIpInterface createIpInterfaceOnNode() throws UnknownHostException {
        OnmsIpInterface ip = this.createIpInterface();
        this.createNode().addIpInterface(ip);
        return ip;
    }
}

