/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.model.HeatMapElement;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.ServiceSelector;
import org.opennms.netmgt.model.outage.OutageSummary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate3.HibernateCallback;

public class OutageDaoHibernate
extends AbstractDaoHibernate<OnmsOutage, Integer>
implements OutageDao {
    @Autowired
    private FilterDao m_filterDao;

    public OutageDaoHibernate() {
        super(OnmsOutage.class);
    }

    public Integer currentOutageCount() {
        return this.queryInt("select count(*) from OnmsOutage as o where o.ifRegainedService is null");
    }

    public Collection<OnmsOutage> currentOutages() {
        return this.find("from OnmsOutage as o where o.ifRegainedService is null");
    }

    public OnmsOutage currentOutageForService(OnmsMonitoredService service) {
        return (OnmsOutage)this.findUnique("from OnmsOutage as o where o.monitoredService = ? and o.ifRegainedService is null", service);
    }

    public Collection<OnmsOutage> findAll(final Integer offset, final Integer limit) {
        return (Collection)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Collection<OnmsOutage>>(){

            public Collection<OnmsOutage> doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createCriteria(OnmsOutage.class).setFirstResult(offset.intValue()).setMaxResults(limit.intValue()).list();
            }
        });
    }

    public Collection<OnmsOutage> matchingCurrentOutages(ServiceSelector selector) {
        HashSet matchingAddrs = new HashSet(this.m_filterDao.getIPAddressList(selector.getFilterRule()));
        HashSet matchingSvcs = new HashSet(selector.getServiceNames());
        LinkedList<OnmsOutage> matchingOutages = new LinkedList<OnmsOutage>();
        Collection<OnmsOutage> outages = this.currentOutages();
        for (OnmsOutage outage : outages) {
            OnmsMonitoredService svc = outage.getMonitoredService();
            if (!matchingSvcs.contains(svc.getServiceName()) && !matchingSvcs.isEmpty() || !matchingAddrs.contains(svc.getIpAddress())) continue;
            matchingOutages.add(outage);
        }
        return matchingOutages;
    }

    public int countOutagesByNode() {
        return this.getNodeOutageSummaries(0).size();
    }

    public List<OutageSummary> getNodeOutageSummaries(int rows) {
        List<OutageSummary> outages = this.findObjects(OutageSummary.class, "SELECT DISTINCT new org.opennms.netmgt.model.outage.OutageSummary(node.id, node.label, max(outage.ifLostService)) FROM OnmsOutage AS outage LEFT JOIN outage.monitoredService AS monitoredService LEFT JOIN monitoredService.ipInterface AS ipInterface LEFT JOIN ipInterface.node AS node WHERE outage.ifRegainedService IS NULL GROUP BY node.id, node.label ORDER BY max(outage.ifLostService) DESC, node.label ASC, node.id ASC", new Object[0]);
        if (rows == 0 || outages.size() < rows) {
            return outages;
        }
        return outages.subList(0, rows);
    }

    public List<HeatMapElement> getHeatMapItemsForEntity(final String entityNameColumn, final String entityIdColumn, final String restrictionColumn, final String restrictionValue, String ... groupByColumns) {
        String grouping = "";
        if (groupByColumns != null && groupByColumns.length > 0) {
            for (String groupByColumn : groupByColumns) {
                if (!"".equals(grouping)) {
                    grouping = grouping + ", ";
                }
                grouping = grouping + groupByColumn;
            }
        } else {
            grouping = entityNameColumn + ", " + entityIdColumn;
        }
        final String groupByClause = grouping;
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<HeatMapElement>>(){

            public List<HeatMapElement> doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createSQLQuery("select coalesce(" + entityNameColumn + ",'Uncategorized'), " + entityIdColumn + ", " + "count(distinct case when outages.outageid is not null and ifservices.status <> 'D' then ifservices.id else null end) as servicesDown, " + "count(distinct case when ifservices.status <> 'D' then ifservices.id else null end) as servicesTotal, " + "count(distinct case when outages.outageid is null and ifservices.status <> 'D' then node.nodeid else null end) as nodesUp, " + "count(distinct node.nodeid) as nodeTotalCount " + "from node left " + "join category_node using (nodeid) left join categories using (categoryid) " + "left outer join ipinterface using (nodeid) " + "left outer join ifservices on (ifservices.ipinterfaceid = ipinterface.id) " + "left outer join service on (ifservices.serviceid = service.serviceid) " + "left outer join outages on (outages.ifserviceid = ifservices.id and outages.ifregainedservice is null) " + "where nodeType <> 'D' " + (restrictionColumn != null ? "and coalesce(" + restrictionColumn + ",'Uncategorized')='" + restrictionValue + "' " : "") + "group by " + groupByClause + " having count(distinct case when ifservices.status <> 'D' then ifservices.id else null end) > 0").setResultTransformer(new ResultTransformer(){
                    private static final long serialVersionUID = 5152094813503430377L;

                    public Object transformTuple(Object[] tuple, String[] aliases) {
                        return new HeatMapElement((String)tuple[0], (Number)tuple[1], (Number)tuple[2], (Number)tuple[3], (Number)tuple[4], (Number)tuple[5]);
                    }

                    public List transformList(List collection) {
                        return collection;
                    }
                }).list();
            }
        });
    }
}

