/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.dao.support.NodeResourceType;
import org.opennms.netmgt.dao.support.ResponseTimeResourceType;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourcePath;

public class ResponseTimeResourceTypeTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private FilesystemResourceStorageDao resourceStorageDao = new FilesystemResourceStorageDao();
    private IpInterfaceDao ipInterfaceDao = (IpInterfaceDao)EasyMock.createMock(IpInterfaceDao.class);
    private OnmsNode node = (OnmsNode)EasyMock.createMock(OnmsNode.class);
    private OnmsIpInterface ipInterface = (OnmsIpInterface)EasyMock.createMock(OnmsIpInterface.class);
    private Set<OnmsIpInterface> ipInterfaces = new HashSet<OnmsIpInterface>();
    private ResponseTimeResourceType responseTimeResourceType = new ResponseTimeResourceType((ResourceStorageDao)this.resourceStorageDao, this.ipInterfaceDao);
    private NodeDao nodeDao = (NodeDao)EasyMock.createMock(NodeDao.class);
    private ResourceDao resourceDao = (ResourceDao)EasyMock.createMock(ResourceDao.class);

    @Before
    public void setUp() throws IOException {
        this.resourceStorageDao.setRrdDirectory(this.tempFolder.getRoot());
        this.resourceStorageDao.setRrdExtension(".rrd");
        File ifResponseFolder = this.tempFolder.newFolder(new String[]{"response", "127.0.0.1"});
        File http = new File(ifResponseFolder, "http.rrd");
        http.createNewFile();
        this.ipInterfaces.add(this.ipInterface);
    }

    @Test
    public void canGetResourcesForNode() throws IOException {
        EasyMock.expect((Object)this.node.getIpInterfaces()).andReturn(this.ipInterfaces);
        EasyMock.expect((Object)this.ipInterface.getIpAddress()).andReturn((Object)InetAddress.getByName("127.0.0.1")).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.node, this.ipInterface});
        NodeResourceType nodeResourceType = new NodeResourceType(this.resourceDao, this.nodeDao);
        OnmsResource nodeResource = new OnmsResource("1", "Node", (OnmsResourceType)nodeResourceType, Collections.emptySet(), ResourcePath.get((String[])new String[]{"foo"}));
        nodeResource.setEntity((OnmsEntity)this.node);
        List resources = this.responseTimeResourceType.getResourcesForParent(nodeResource);
        EasyMock.verify((Object[])new Object[]{this.node, this.ipInterface});
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"127.0.0.1", (Object)((OnmsResource)resources.get(0)).getName());
    }

    @Test
    public void canGetChildByName() throws IOException {
        EasyMock.expect((Object)this.ipInterfaceDao.get(this.node, "127.0.0.1")).andReturn((Object)this.ipInterface);
        OnmsResource parent = (OnmsResource)EasyMock.createMock(OnmsResource.class);
        EasyMock.expect((Object)parent.getEntity()).andReturn((Object)this.node);
        EasyMock.replay((Object[])new Object[]{this.ipInterface, parent, this.ipInterfaceDao});
        OnmsResource resource = this.responseTimeResourceType.getChildByName(parent, "127.0.0.1");
        EasyMock.verify((Object[])new Object[]{this.ipInterface, parent, this.ipInterfaceDao});
        Assert.assertEquals((Object)"127.0.0.1", (Object)resource.getName());
        Assert.assertEquals((Object)parent, (Object)resource.getParent());
    }
}

