/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.opennms.netmgt.dao.api.IsIsLinkDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.IsIsLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.topology.IsisTopologyLink;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.util.Assert;

public class IsIsLinkDaoHibernate
extends AbstractDaoHibernate<IsIsLink, Integer>
implements IsIsLinkDao {
    private static final String SQL_GET_ISIS_LINKS = "select distinct on (distinct_id) least(l1.id, l2.id) as distinct_id, l1.id as source_id, l1.nodeid as source_nodeid, n.nodelabel as sourcenodelabel, n.nodesysoid as sourcenodesysoid, n.nodesyslocation as sourcenodelocation, n.nodetype as sourcenodetype, l1.isiscircifindex as l1_isiscircifindex, l2.id as target_id,  l2.nodeid as target_nodeid, np.nodelabel as targetnodelabel, np.nodesysoid as targetnodesysoid, np.nodesyslocation as targetnodelocation, np.nodetype as targetnodetype, l2.isiscircifindex as l2_isiscircifindex from isislink l1 left join isiselement e1 on l1.nodeid = e1.nodeid left join node n on n.nodeid = e1.nodeid left join isiselement e2 on l1.isisisadjneighsysid = e2.isissysid left join node np on np.nodeid = e2.nodeid left join isislink l2 on e2.nodeid=l2.nodeid where l1.isisisadjindex = l2.isisisadjindex and l2.isisisadjneighsysid = e1.isissysid order by distinct_id;";

    public IsIsLinkDaoHibernate() {
        super(IsIsLink.class);
    }

    public IsIsLink get(OnmsNode node, Integer isisCircIndex, Integer isisISAdjIndex) {
        return (IsIsLink)this.findUnique("from IsIsLink as isisLink where isisLink.node = ? and isisLink.isisCircIndex = ? and isisLink.isisISAdjIndex = ? ", node, isisCircIndex, isisISAdjIndex);
    }

    public IsIsLink get(Integer nodeId, Integer isisCircIndex, Integer isisISAdjIndex) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        Assert.notNull((Object)isisCircIndex, (String)"isisCircIndex cannot be null");
        Assert.notNull((Object)isisISAdjIndex, (String)"isisISAdjIndex cannot be null");
        return (IsIsLink)this.findUnique("from IsIsLink as isisLink where isisLink.node.id = ? and isisLink.isisCircIndex = ? and isisLink.isisISAdjIndex = ? ", nodeId, isisCircIndex, isisISAdjIndex);
    }

    public List<IsIsLink> findByNodeId(Integer nodeId) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        return this.find("from IsIsLink isisLink where isisLink.node.id = ?", nodeId);
    }

    public void deleteByNodeIdOlderThen(Integer nodeId, Date now) {
        for (IsIsLink link : this.find("from IsIsLink isisLink where isisLink.node.id = ? and isisLinkLastPollTime < ?", nodeId, now)) {
            this.delete(link);
        }
    }

    private List<IsisTopologyLink> convertObjectToTopologyLink(List<Object[]> list) {
        ArrayList<IsisTopologyLink> topoLinks = new ArrayList<IsisTopologyLink>();
        for (Object[] objs : list) {
            Integer targetId = (Integer)objs[8];
            Integer targetNodeId = (Integer)objs[9];
            if (targetId == null || targetNodeId == null) continue;
            topoLinks.add(new IsisTopologyLink((Integer)objs[1], (Integer)objs[2], (String)objs[3], (String)objs[4], (String)objs[5], OnmsNode.NodeType.getNodeTypeFromChar((char)((Character)objs[6]).charValue()), (Integer)objs[7], (Integer)objs[8], (Integer)objs[9], (String)objs[10], (String)objs[11], (String)objs[12], OnmsNode.NodeType.getNodeTypeFromChar((char)((Character)objs[13]).charValue()), (Integer)objs[14]));
        }
        return topoLinks;
    }

    public List<IsisTopologyLink> getLinksForTopology() {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<IsisTopologyLink>>(){

            public List<IsisTopologyLink> doInHibernate(Session session) throws HibernateException, SQLException {
                return IsIsLinkDaoHibernate.this.convertObjectToTopologyLink(session.createSQLQuery(IsIsLinkDaoHibernate.SQL_GET_ISIS_LINKS).list());
            }
        });
    }
}

