/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.net.InetAddress;
import java.util.Date;
import java.util.List;
import org.opennms.netmgt.dao.api.IpNetToMediaDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.IpNetToMedia;

public class IpNetToMediaDaoHibernate
extends AbstractDaoHibernate<IpNetToMedia, Integer>
implements IpNetToMediaDao {
    public IpNetToMediaDaoHibernate() {
        super(IpNetToMedia.class);
    }

    public List<IpNetToMedia> findBySourceNodeId(Integer id) {
        return this.find("from IpNetToMedia rec where rec.sourceNode.id = ?", id);
    }

    public IpNetToMedia getByNetAndPhysAddress(InetAddress netAddress, String physAddress) {
        return (IpNetToMedia)this.findUnique("from IpNetToMedia rec where rec.netAddress = ? and rec.physAddress = ?", netAddress, physAddress);
    }

    public void deleteBySourceNodeIdOlderThen(Integer nodeId, Date now) {
        for (IpNetToMedia elem : this.find("from IpNetToMedia rec where rec.sourceNode.id = ? and rec.lastPollTime < ?", nodeId, now)) {
            this.delete(elem);
        }
    }

    public List<IpNetToMedia> findByPhysAddress(String physAddress) {
        return this.find("from IpNetToMedia rec where rec.physAddress = ?", physAddress);
    }

    public List<IpNetToMedia> findByNetAddress(InetAddress netAddress) {
        return this.find("from IpNetToMedia rec where rec.netAddress = ? ", netAddress);
    }
}

