/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.opennms.netmgt.dao.api.CdpLinkDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.topology.CdpTopologyLink;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.util.Assert;

public class CdpLinkDaoHibernate
extends AbstractDaoHibernate<CdpLink, Integer>
implements CdpLinkDao {
    private static String SQL_CDP_LINK_BASE_QUERY = "select l.id as sourceid, l.nodeid as sourcenodeid, n.nodelabel as sourcenodelabel, n.nodesysoid as sourcenodesysoid, n.nodesyslocation as sourcenodelocation, n.nodetype as sourcenodetype, l.cdpcacheifindex as sourceifindex, l.cdpinterfacename as sourceifname, e.id as targetid, e.nodeid as targetnodeid, np.nodelabel as targetnodelabel, np.nodesysoid as targetnodesysoid, np.nodesyslocation as targetnodelocation, np.nodetype as targetnodetype, l.cdpcachedeviceport as targetifname from cdplink l left join node n on l.nodeid = n.nodeid right join ipinterface e on l.cdpcacheaddress = e.ipaddr left join node np on e.nodeid = np.nodeid where l.cdpcacheaddresstype=1";

    public CdpLinkDaoHibernate() {
        super(CdpLink.class);
    }

    public CdpLink get(OnmsNode node, Integer cdpCacheifIndex, Integer cdpCacheDeviceIndex) {
        Assert.notNull((Object)node, (String)"node cannot be null");
        Assert.notNull((Object)cdpCacheifIndex, (String)"cdpCacheifIndex cannot be null");
        Assert.notNull((Object)cdpCacheDeviceIndex, (String)"cdpCacheDeviceIndex cannot be null");
        return (CdpLink)this.findUnique("from CdpLink as cdpLink where cdpLink.node = ? and cdpLink.cdpCacheIfIndex = ? and cdpCacheDeviceIndex = ?", node, cdpCacheifIndex, cdpCacheDeviceIndex);
    }

    public CdpLink get(Integer nodeId, Integer cdpCacheifIndex, Integer cdpCacheDeviceIndex) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        Assert.notNull((Object)cdpCacheifIndex, (String)"cdpCacheifIndex cannot be null");
        Assert.notNull((Object)cdpCacheDeviceIndex, (String)"cdpCacheDeviceIndex cannot be null");
        return (CdpLink)this.findUnique("from CdpLink as cdpLink where cdpLink.node.id = ? and cdpLink.cdpCacheIfIndex = ? and cdpCacheDeviceIndex = ?", nodeId, cdpCacheifIndex, cdpCacheDeviceIndex);
    }

    public List<CdpLink> findByNodeId(Integer nodeId) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        return this.find("from CdpLink cdpLink where cdpLink.node.id = ?", nodeId);
    }

    private List<CdpTopologyLink> convertObjectToTopologyLink(List<Object[]> list) {
        ArrayList<CdpTopologyLink> topoLinks = new ArrayList<CdpTopologyLink>();
        for (Object[] objs : list) {
            Integer targetId = (Integer)objs[8];
            Integer targetNodeId = (Integer)objs[9];
            if (targetId == null || targetNodeId == null) continue;
            topoLinks.add(new CdpTopologyLink((Integer)objs[0], (Integer)objs[1], (String)objs[2], (String)objs[3], (String)objs[4], OnmsNode.NodeType.getNodeTypeFromChar((char)((Character)objs[5]).charValue()), (Integer)objs[6], (String)objs[7], (Integer)objs[8], (Integer)objs[9], (String)objs[10], (String)objs[11], (String)objs[12], OnmsNode.NodeType.getNodeTypeFromChar((char)((Character)objs[13]).charValue()), (String)objs[14]));
        }
        return topoLinks;
    }

    public List<CdpTopologyLink> findLinksForTopology() {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<CdpTopologyLink>>(){

            public List<CdpTopologyLink> doInHibernate(Session session) throws HibernateException, SQLException {
                return CdpLinkDaoHibernate.this.convertObjectToTopologyLink(session.createSQLQuery(SQL_CDP_LINK_BASE_QUERY + ";").list());
            }
        });
    }

    public List<CdpTopologyLink> findLinksForTopologyByIds(final Integer ... ids) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<CdpTopologyLink>>(){

            public List<CdpTopologyLink> doInHibernate(Session session) throws HibernateException, SQLException {
                StringBuffer idList = new StringBuffer();
                String conditional = "";
                if (ids.length > 0) {
                    for (int i = 0; i < ids.length; ++i) {
                        if (i > 0) {
                            idList.append(", ");
                        }
                        idList.append(ids[i]);
                    }
                    conditional = " and (l.id in (" + idList.toString() + ") or e.id in (" + idList.toString() + "))";
                }
                return CdpLinkDaoHibernate.this.convertObjectToTopologyLink(session.createSQLQuery(SQL_CDP_LINK_BASE_QUERY + conditional.toString() + ";").list());
            }
        });
    }

    public void deleteByNodeIdOlderThen(Integer nodeId, Date now) {
        for (CdpLink link : this.find("from CdpLink cdpLink where cdpLink.node.id = ? and cdpLink.cdpLinkLastPollTime < ?", nodeId, now)) {
            this.delete(link);
        }
    }
}

